/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import eu.clarussecure.dataoperations.AttributeNamesUtilities;
import eu.clarussecure.dataoperations.anonymization.Circle;
import eu.clarussecure.dataoperations.anonymization.Cluster;
import eu.clarussecure.dataoperations.anonymization.ClusterPoints;
import eu.clarussecure.dataoperations.anonymization.ComparatorID;
import eu.clarussecure.dataoperations.anonymization.ComparatorIdCircles;
import eu.clarussecure.dataoperations.anonymization.ComparatorQuasi;
import eu.clarussecure.dataoperations.anonymization.ComparatorSensitive;
import eu.clarussecure.dataoperations.anonymization.CoordinateS;
import eu.clarussecure.dataoperations.anonymization.Distances;
import eu.clarussecure.dataoperations.anonymization.FileReader2;
import eu.clarussecure.dataoperations.anonymization.Record;
import eu.clarussecure.dataoperations.anonymization.RecordQ;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.geometry.jts.GeometryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);

    public static String[][] anonymize(String[] attributes, String[][] content) {
        String[][] dataAnom = null;
        Functions.reOrderListsAccordingAttributeParameter(attributes);
        if (Record.attrTypes.get("quasi_identifier").equalsIgnoreCase("k-anonymity") && Record.attrTypes.get("confidential").equalsIgnoreCase("t-closeness")) {
            dataAnom = Functions.kAnonymize_tCloseness(content, Record.k, Record.t);
            return dataAnom;
        }
        if (Record.attrTypes.get("quasi_identifier").equalsIgnoreCase("k-anonymity")) {
            dataAnom = Functions.kAnonymize(content, Record.k);
            return dataAnom;
        }
        if (Record.attrTypes.get("identifier").equalsIgnoreCase("coarsening") && Record.coarsening_type.equalsIgnoreCase("shift")) {
            dataAnom = Functions.coarseningShift(content, Record.radius);
            return dataAnom;
        }
        if (Record.attrTypes.get("identifier").equalsIgnoreCase("coarsening") && Record.coarsening_type.equalsIgnoreCase("microaggregation")) {
            dataAnom = Functions.coarseningMicroaggregation(content, Record.k);
            return dataAnom;
        }
        return dataAnom;
    }

    private static void reOrderListsAccordingAttributeParameter(String[] attributes) {
        ArrayList<String> newListNames = new ArrayList<String>();
        ArrayList<Pattern> newListNamePatterns = new ArrayList<Pattern>();
        ArrayList<String> newListAttrTypes = new ArrayList<String>();
        ArrayList<String> newListDataTypes = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            String attr = attributes[i];
            boolean ok = false;
            for (int j = 0; j < Record.refListNames.size(); ++j) {
                String name = Record.refListNames.get(j);
                Pattern pattern = Record.refListNamePatterns.get(j);
                if (!pattern.matcher(attr).matches()) continue;
                newListNames.add(name);
                newListNamePatterns.add(Record.refListNamePatterns.get(j));
                newListAttrTypes.add(Record.refListAttrTypes.get(j));
                newListDataTypes.add(Record.refListDataTypes.get(j));
                ok = true;
                break;
            }
            if (ok) continue;
            newListNames.add(attr);
            newListNamePatterns.add(Pattern.compile(AttributeNamesUtilities.escapeRegex((String)attr)));
            newListAttrTypes.add("non_confidential");
            newListDataTypes.add("categoric");
        }
        Record.listNames = newListNames;
        Record.listAttrTypes = newListAttrTypes;
        Record.listDataTypes = newListDataTypes;
        Record.numAttr = newListNames.size();
    }

    public static String[][] kAnonymize(String[][] dataOri, int k) {
        ArrayList<Record> data = Functions.createRecords(dataOri);
        ArrayList<Record> dataAnom = Functions.kAnonymize(data, k);
        String[][] dataAnomStr = Functions.createMatrixStringFromRecords(dataAnom);
        return dataAnomStr;
    }

    public static ArrayList<Record> kAnonymize(ArrayList<Record> dataOri, int k) {
        int i;
        ArrayList<RecordQ> dataQuasis = new ArrayList<RecordQ>();
        ArrayList<Record> dataAnom = new ArrayList<Record>();
        LOGGER.trace("Anonymizing kAnonymity k = {}...", (Object)k);
        RecordQ.numAttr = Record.numQuasi;
        RecordQ.listAttrTypes = new ArrayList();
        RecordQ.listDataTypes = new ArrayList();
        for (int i2 = 0; i2 < Record.numAttr; ++i2) {
            String attrType = Record.listAttrTypes.get(i2);
            if (!attrType.equalsIgnoreCase("quasi_identifier")) continue;
            RecordQ.listAttrTypes.add(Record.listAttrTypes.get(i2));
            RecordQ.listDataTypes.add(Record.listDataTypes.get(i2));
        }
        for (Record reg : dataOri) {
            dataQuasis.add(reg.toRecordQ());
        }
        Distances.calculateTypicalDeviationsNumeric(dataQuasis);
        LOGGER.debug("Sorting by quasi-identifiers done");
        Functions.sortByQuasi(dataQuasis);
        System.out.println("done");
        LOGGER.trace("Anonymizing...");
        Cluster cluster = new Cluster();
        int numReg = dataQuasis.size();
        int pos = 0;
        int remain = numReg;
        while (remain >= 2 * k) {
            int i3;
            for (i3 = 0; i3 < k; ++i3) {
                cluster.add(dataQuasis.get(pos));
                ++pos;
            }
            cluster.calculateCentroid();
            pos -= k;
            for (i3 = 0; i3 < k; ++i3) {
                for (int j = 0; j < RecordQ.numAttr; ++j) {
                    dataQuasis.get((int)pos).attrValues[j] = cluster.getCentroid().attrValues[j];
                }
                ++pos;
            }
            cluster.clear();
            remain = numReg - pos;
        }
        for (i = 0; i < remain; ++i) {
            cluster.add(dataQuasis.get(pos));
            ++pos;
        }
        cluster.calculateCentroid();
        pos -= remain;
        for (i = 0; i < remain; ++i) {
            for (int j = 0; j < RecordQ.numAttr; ++j) {
                dataQuasis.get((int)pos).attrValues[j] = cluster.getCentroid().attrValues[j];
            }
            ++pos;
        }
        LOGGER.debug("Anonymizing done...");
        LOGGER.trace("Rearranging...");
        Collections.sort(dataQuasis, new ComparatorID());
        for (i = 0; i < dataQuasis.size(); ++i) {
            RecordQ recordQ = dataQuasis.get(i);
            Record record = dataOri.get(i).clone();
            dataAnom.add(recordQ.toRecord(record));
        }
        LOGGER.debug("Rearranging done...");
        LOGGER.debug("Anonymizing done (kAnonymity k = {})", (Object)k);
        return dataAnom;
    }

    public static String[][] kAnonymize_tCloseness(String[][] dataOri, int k, double t) {
        ArrayList<Record> data = Functions.createRecords(dataOri);
        ArrayList<Record> dataAnom = Functions.kAnonymize_tCloseness(data, k, t);
        String[][] dataAnomStr = Functions.createMatrixStringFromRecords(dataAnom);
        return dataAnomStr;
    }

    public static ArrayList<Record> kAnonymize_tCloseness(ArrayList<Record> dataOri, int k, double t) {
        RecordQ r;
        Cluster clusterTemp;
        int i;
        String attrType;
        int i2;
        ArrayList<RecordQ> dataQuasis = new ArrayList<RecordQ>();
        ArrayList<Record> dataAnom = new ArrayList<Record>();
        ArrayList<Cluster> clustersK = new ArrayList<Cluster>();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        LOGGER.trace("Anonymizing kAnonymity / tCloseness k = {} / t = {}...", (Object)k, (Object)t);
        RecordQ.numAttr = Record.numQuasi + 1;
        RecordQ.listAttrTypes = new ArrayList();
        RecordQ.listDataTypes = new ArrayList();
        for (i2 = 0; i2 < Record.numAttr; ++i2) {
            attrType = Record.listAttrTypes.get(i2);
            if (!attrType.equalsIgnoreCase("quasi_identifier")) continue;
            RecordQ.listAttrTypes.add(Record.listAttrTypes.get(i2));
            RecordQ.listDataTypes.add(Record.listDataTypes.get(i2));
        }
        for (i2 = 0; i2 < Record.numAttr; ++i2) {
            attrType = Record.listAttrTypes.get(i2);
            if (!attrType.equalsIgnoreCase("confidential")) continue;
            RecordQ.listAttrTypes.add(Record.listAttrTypes.get(i2));
            RecordQ.listDataTypes.add(Record.listDataTypes.get(i2));
        }
        for (Record reg : dataOri) {
            dataQuasis.add(reg.toRecordQConfidential());
        }
        Distances.calculateTypicalDeviationsNumericWithConfidential(dataQuasis);
        LOGGER.trace("Sorting by confidential attribute...");
        int attrSensitive = dataQuasis.get((int)0).attrValues.length - 1;
        Functions.sortBySensitive(dataQuasis, attrSensitive);
        LOGGER.debug("Sorting by confidential attribute done");
        int n = dataQuasis.size();
        double kPrime = (double)n / ((double)(2 * (n - 1)) * t + 1.0);
        int numClustersK = (double)k > kPrime ? k : (int)kPrime + 1;
        int numItem = dataQuasis.size() / numClustersK;
        int remainder = dataQuasis.size() % numClustersK;
        if (remainder >= numItem) {
            numClustersK += remainder / numItem;
        }
        LOGGER.trace("Creating k subsets({})...", (Object)numClustersK);
        int index = 0;
        for (i = 0; i < numClustersK; ++i) {
            clusterTemp = new Cluster();
            for (int j = 0; j < numItem; ++j) {
                r = dataQuasis.get(index);
                clusterTemp.add(r);
                ++index;
            }
            clustersK.add(clusterTemp);
        }
        if (index < dataQuasis.size()) {
            clusterTemp = new Cluster();
            for (i = index; i < dataQuasis.size(); ++i) {
                r = dataQuasis.get(i);
                clusterTemp.add(r);
            }
            clustersK.add(clusterTemp);
        }
        LOGGER.debug("Creating k subsets({}) done", (Object)numClustersK);
        LOGGER.trace("Sorting by quasi-identifier attributes each subset...");
        for (Cluster cluster : clustersK) {
            Functions.sortByQuasi(cluster.getElements());
        }
        LOGGER.debug("Sorting by quasi-identifier attributes each subset done");
        LOGGER.trace("Creating clusters...");
        int remain = dataQuasis.size();
        dataQuasis.clear();
        index = 0;
        while (remain > 0) {
            clusterTemp = new Cluster();
            for (Cluster cluster : clustersK) {
                if (cluster.getElements().size() <= index) continue;
                clusterTemp.add(cluster.getElements().get(index));
                --remain;
            }
            ++index;
            clusters.add(clusterTemp);
        }
        LOGGER.debug("Creating clusters done");
        LOGGER.trace("Anonymizing...");
        int numAttrQuasi = ((Cluster)clusters.get((int)0)).getElements().get((int)0).attrValues.length - 1;
        for (Cluster cluster : clusters) {
            cluster.calculateCentroid();
            for (RecordQ reg : cluster.getElements()) {
                for (int j = 0; j < numAttrQuasi; ++j) {
                    reg.attrValues[j] = cluster.getCentroid().attrValues[j];
                }
                dataQuasis.add(reg);
            }
        }
        LOGGER.debug("Anonymizing done");
        LOGGER.trace("ReArranging...");
        Collections.sort(dataQuasis, new ComparatorID());
        for (int i3 = 0; i3 < dataQuasis.size(); ++i3) {
            RecordQ recordQ = dataQuasis.get(i3);
            dataAnom.add(recordQ.toRecord(dataOri.get(i3)));
        }
        LOGGER.debug("ReArranging done");
        LOGGER.debug("Anonymizing done (kAnonymity / tCloseness k = {} / t = {})", (Object)k, (Object)t);
        return dataAnom;
    }

    public static String[][] coarseningShift(String[][] dataOri, double radius) {
        ArrayList<Record> data = Functions.createRecords(dataOri);
        ArrayList<Record> dataAnom = Functions.coarseningShift(data, radius);
        String[][] dataAnomStr = Functions.createMatrixStringFromRecords(dataAnom);
        return dataAnomStr;
    }

    public static ArrayList<Record> coarseningShift(ArrayList<Record> dataOri, double radius) {
        ArrayList<Record> dataAnom = new ArrayList<Record>();
        ArrayList<String> geometricObjects = new ArrayList<String>();
        ArrayList<String> geometricObjectsAnom = new ArrayList<String>();
        WKBReader wkbReader = new WKBReader();
        WKBWriter wkbWriter = new WKBWriter(2, true);
        WKTReader wktReader = new WKTReader();
        WKTWriter wktWriter = new WKTWriter(2);
        LOGGER.trace("Coarsening radius = {}...", (Object)radius);
        int posGeom = 0;
        for (int i = 0; i < Record.numAttr; ++i) {
            String dataType;
            String attrType = Record.listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("identifier") || !(dataType = Record.listDataTypes.get(i)).equalsIgnoreCase("geometric_object")) continue;
            posGeom = i;
            break;
        }
        for (Record reg : dataOri) {
            String geomStr = reg.attrValues[posGeom];
            geometricObjects.add(geomStr);
        }
        for (String s : geometricObjects) {
            boolean wktFormat = true;
            boolean withSRID = false;
            Geometry geom = null;
            try {
                int srid = 0;
                String wkt = s;
                withSRID = wkt.startsWith("SRID");
                if (withSRID) {
                    int begin = wkt.indexOf(61) + 1;
                    int end = wkt.indexOf(59, begin);
                    srid = Integer.parseInt(wkt.substring(begin, end));
                    wkt = wkt.substring(end + 1);
                }
                geom = wktReader.read(wkt);
                geom.setSRID(srid);
            }
            catch (ParseException e) {
                wktFormat = false;
                try {
                    geom = wkbReader.read(WKBReader.hexToBytes((String)s));
                }
                catch (ParseException e2) {
                    e.printStackTrace();
                }
            }
            if (geom == null) continue;
            double x = geom.getCoordinate().x;
            double y = geom.getCoordinate().y;
            Circle circle = Functions.shift(x, y, radius);
            Geometry cir = Functions.create3DCircle(circle.centre.latitude, circle.centre.longitude, radius);
            cir.setSRID(geom.getSRID());
            if (wktFormat) {
                s = wktWriter.write(cir);
                if (withSRID) {
                    s = "SRID=" + cir.getSRID() + ";" + s;
                }
            } else {
                s = WKBWriter.toHex((byte[])wkbWriter.write(cir));
            }
            geometricObjectsAnom.add(s);
        }
        for (int i = 0; i < dataOri.size(); ++i) {
            Record record = dataOri.get(i);
            Record recordAnom = record.clone();
            recordAnom.attrValues[posGeom] = (String)geometricObjectsAnom.get(i);
            dataAnom.add(recordAnom);
        }
        LOGGER.debug("Coarsening done (radius = {})", (Object)radius);
        return dataAnom;
    }

    public static String[][] coarseningMicroaggregation(String[][] dataOri, int k) {
        ArrayList<Record> data = Functions.createRecords(dataOri);
        ArrayList<Record> dataAnom = Functions.coarseningMicroaggregation(data, k);
        String[][] dataAnomStr = Functions.createMatrixStringFromRecords(dataAnom);
        return dataAnomStr;
    }

    public static ArrayList<Record> coarseningMicroaggregation(ArrayList<Record> dataOri, int k) {
        ClusterPoints cluster;
        CoordinateS farthest;
        CoordinateS centroid;
        String geomStr;
        ArrayList<Record> dataAnom = new ArrayList<Record>();
        ArrayList<String> geometricObjectsAnom = new ArrayList<String>();
        ArrayList<CoordinateS> pointsAnom = new ArrayList<CoordinateS>();
        ArrayList<Circle> circles = new ArrayList<Circle>();
        ArrayList<ClusterPoints> clusters = new ArrayList<ClusterPoints>();
        WKBReader wkbReader = new WKBReader();
        WKBWriter wkbWriter = new WKBWriter(2, true);
        WKTReader wktReader = new WKTReader();
        WKTWriter wktWriter = new WKTWriter(2);
        LOGGER.trace("Coarsening microaggregation k = {}...", (Object)k);
        int posGeom = 0;
        for (int i = 0; i < Record.numAttr; ++i) {
            String dataType;
            String attrType = Record.listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("identifier") || !(dataType = Record.listDataTypes.get(i)).equalsIgnoreCase("geometric_object")) continue;
            posGeom = i;
            break;
        }
        boolean wktFormat = true;
        boolean withSRID = false;
        for (Record record : dataOri) {
            geomStr = record.attrValues[posGeom];
            Geometry geom = null;
            try {
                int srid = 0;
                String wkt = geomStr;
                withSRID = wkt.startsWith("SRID");
                if (withSRID) {
                    int begin = wkt.indexOf(61) + 1;
                    int end = wkt.indexOf(59, begin);
                    srid = Integer.parseInt(wkt.substring(begin, end));
                    wkt = wkt.substring(end + 1);
                }
                geom = wktReader.read(wkt);
                geom.setSRID(srid);
            }
            catch (ParseException e) {
                wktFormat = false;
                try {
                    geom = wkbReader.read(WKBReader.hexToBytes((String)geomStr));
                }
                catch (ParseException e2) {
                    e.printStackTrace();
                }
            }
            if (geom == null) continue;
            double x = geom.getCoordinate().x;
            double y = geom.getCoordinate().y;
            pointsAnom.add(new CoordinateS(y, x, record.id, geom.getSRID()));
        }
        while (pointsAnom.size() >= k) {
            centroid = Functions.calculateCentroid(pointsAnom);
            farthest = Functions.calculateFarthestPoint(centroid, pointsAnom);
            cluster = new ClusterPoints();
            cluster.add(farthest);
            pointsAnom.remove(farthest);
            centroid = cluster.calculateCentroid();
            while (cluster.getNumPoints() < k) {
                CoordinateS closest = Functions.calculateClosestPoint(centroid, pointsAnom);
                cluster.add(closest);
                pointsAnom.remove(closest);
                centroid = cluster.calculateCentroid();
            }
            clusters.add(cluster);
        }
        for (CoordinateS coordinateS : pointsAnom) {
            cluster = Functions.calculateClosestCluster(coordinateS, clusters);
            cluster.add(coordinateS);
            cluster.calculateCentroid();
        }
        for (ClusterPoints clusterPoints : clusters) {
            centroid = clusterPoints.getCentroid();
            farthest = Functions.calculateFarthestPoint(centroid, clusterPoints.getPoints());
            double distance = Math.sqrt(centroid.distanceSq(farthest));
            for (CoordinateS coo : clusterPoints.getPoints()) {
                Circle circle = new Circle(centroid, distance);
                circle.centre.id = coo.id;
                circle.centre.srid = coo.srid;
                circles.add(circle);
            }
        }
        Collections.sort(circles, new ComparatorIdCircles());
        for (Circle circle : circles) {
            Geometry cir = Functions.create3DCircle(circle.centre.latitude, circle.centre.longitude, circle.radius);
            cir.setSRID(circle.centre.srid);
            if (wktFormat) {
                geomStr = wktWriter.write(cir);
                if (withSRID) {
                    geomStr = "SRID=" + cir.getSRID() + ";" + geomStr;
                }
            } else {
                geomStr = WKBWriter.toHex((byte[])wkbWriter.write(cir));
            }
            geometricObjectsAnom.add(geomStr);
        }
        for (int i = 0; i < dataOri.size(); ++i) {
            Record record = dataOri.get(i);
            Record recordAnom = record.clone();
            recordAnom.attrValues[posGeom] = (String)geometricObjectsAnom.get(i);
            dataAnom.add(recordAnom);
        }
        LOGGER.debug("Coarsening microaggregation done (k = {})", (Object)k);
        return dataAnom;
    }

    private static ClusterPoints calculateClosestCluster(CoordinateS point, ArrayList<ClusterPoints> clusters) {
        ClusterPoints closest = null;
        double minDistance = Double.MAX_VALUE;
        for (ClusterPoints c : clusters) {
            double distance = c.getCentroid().distanceSq(point);
            if (!(distance < minDistance)) continue;
            closest = c;
            minDistance = distance;
        }
        return closest;
    }

    private static CoordinateS calculateClosestPoint(CoordinateS point, ArrayList<CoordinateS> points) {
        CoordinateS closest = null;
        double minDistance = Double.MAX_VALUE;
        for (CoordinateS p : points) {
            double distance = p.distanceSq(point);
            if (!(distance < minDistance)) continue;
            closest = p;
            minDistance = distance;
        }
        return closest;
    }

    private static CoordinateS calculateFarthestPoint(CoordinateS point, ArrayList<CoordinateS> points) {
        CoordinateS farthest = null;
        double maxDistance = 0.0;
        for (CoordinateS p : points) {
            double distance = p.distanceSq(point);
            if (!(distance > maxDistance)) continue;
            farthest = p;
            maxDistance = distance;
        }
        return farthest;
    }

    private static CoordinateS calculateCentroid(ArrayList<CoordinateS> points) {
        double y;
        double x;
        double maxY = -1.7976931348623157E308;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double minX = Double.MAX_VALUE;
        CoordinateS centroid = new CoordinateS(maxX, maxY);
        for (CoordinateS p : points) {
            x = p.latitude;
            y = p.longitude;
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (x < minX) {
                minX = x;
            }
            if (!(y < minY)) continue;
            minY = y;
        }
        x = (maxX + minX) / 2.0;
        y = (maxY + minY) / 2.0;
        centroid.setLocation(x, y);
        return centroid;
    }

    public static int calculateSrid(double x, double y, int srid) {
        int pref = y > 0.0 ? 32600 : 32700;
        int zone = (int)((x + 180.0) / 6.0) + 1;
        return zone + pref;
    }

    private static Geometry create3DCircle(double lat, double lng, double radius) {
        PrecisionModel pmodel = new PrecisionModel();
        GeometryFactory builder = new GeometryFactory(pmodel);
        GeometryBuilder gb = new GeometryBuilder(builder);
        int SIDES = 32 + 16 * new Random().nextInt(4);
        Polygon polygon = gb.circle(lng, lat, radius, SIDES);
        return polygon;
    }

    public static Circle shift(double x1, double y1, double privacy) {
        double theta = ThreadLocalRandom.current().nextDouble(361.0);
        double x2 = x1 + Math.cos(theta) * privacy;
        double y2 = y1 + Math.sin(theta) * privacy;
        double x = x1 + (x2 - x1) * ThreadLocalRandom.current().nextDouble();
        double y = y1 + (y2 - y1) * ThreadLocalRandom.current().nextDouble();
        return new Circle(x, y, privacy);
    }

    private static void sortByQuasi(ArrayList<RecordQ> data) {
        ComparatorQuasi.setAttributeSortCriteria(data.get(0));
        Collections.sort(data, new ComparatorQuasi());
    }

    private static void sortBySensitive(ArrayList<RecordQ> data, int attr) {
        ComparatorSensitive.setAttributeSortCriteria(attr);
        Collections.sort(data, new ComparatorSensitive());
    }

    public static void readPropertiesFromFile(String fileProperties) {
        Document document = Functions.readDocumentFromFile(fileProperties);
        Functions.readProperties(document);
    }

    public static void readProperties(String xml) {
        Document document = Functions.readDocument(xml);
        Functions.readProperties(document);
    }

    public static void readProperties(byte[] xml) {
        Document document = Functions.readDocument(xml);
        Functions.readProperties(document);
    }

    private static Document readDocumentFromFile(String fileProperties) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new File(fileProperties));
            document.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    private static Document readDocument(String xml) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            document = db.parse(is);
            document.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    public static Document readDocument(byte[] xml) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(new String(xml)));
            document = db.parse(is);
            document.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    public static void readProperties(Document document) {
        Record.attrTypes = Functions.getAttributeTypes(document);
        for (String s : Record.attrTypes.values()) {
            if (s.equalsIgnoreCase("k-anonymity")) {
                Record.k = Integer.parseInt(Functions.getK(document));
            }
            if (s.equalsIgnoreCase("t-closeness")) {
                Record.t = Double.parseDouble(Functions.getT(document));
            }
            if (s.equalsIgnoreCase("splitting")) {
                Record.clouds = Integer.parseInt(Functions.getClouds(document));
            }
            if (s.equalsIgnoreCase("encryption")) {
                Record.idKey = Functions.getIdKey(document);
            }
            if (!s.equalsIgnoreCase("coarsening")) continue;
            Record.coarsening_type = Functions.getCoarseningType(document);
            if (Record.coarsening_type.equalsIgnoreCase("shift")) {
                Record.radius = Double.parseDouble(Functions.getRadius(document));
            }
            if (!Record.coarsening_type.equalsIgnoreCase("microaggregation")) continue;
            Record.k = Integer.parseInt(Functions.getCoarseningK(document));
        }
        List<String> attributeNames = Functions.getAtributeNames(document);
        attributeNames = AttributeNamesUtilities.fullyQualified(attributeNames);
        List attributePatterns = attributeNames.stream().map(AttributeNamesUtilities::escapeRegex).map(Pattern::compile).collect(Collectors.toList());
        Record.refListNames = Record.listNames = (ArrayList)attributeNames;
        Record.refListNamePatterns = Record.listNamePatterns = (ArrayList)attributePatterns;
        Record.listAttrTypes = Functions.getAtributeTypes(document);
        Record.refListAttrTypes = Record.listAttrTypes;
        int numQuasis = 0;
        for (String s : Record.listAttrTypes) {
            if (!s.equals("quasi_identifier")) continue;
            ++numQuasis;
        }
        Record.numQuasi = numQuasis;
        if (Record.numQuasi == 0) {
            Record.attrTypes.put("quasi_identifier", "null");
        }
        Record.listDataTypes = Functions.getAttributeDataTypes(document);
        Record.refListDataTypes = Record.listDataTypes;
        Record.refNumAttr = Record.numAttr = Record.listAttrTypes.size();
    }

    private static HashMap<String, String> getAttributeTypes(Document document) {
        HashMap<String, String> attrTypes = new HashMap<String, String>();
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            node = attributes.getNamedItem("type");
            String type = node.getNodeValue();
            node = attributes.getNamedItem("protection");
            String protection = node.getNodeValue();
            attrTypes.put(type, protection);
        }
        return attrTypes;
    }

    private static String getK(Document document) {
        String k = null;
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String protection = (node = attributes.getNamedItem("protection")).getNodeValue();
            if (!protection.equalsIgnoreCase("k-anonymity")) continue;
            node = attributes.getNamedItem("k");
            k = node.getNodeValue();
            break;
        }
        return k;
    }

    private static String getT(Document document) {
        String t = null;
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String protection = (node = attributes.getNamedItem("protection")).getNodeValue();
            if (!protection.equalsIgnoreCase("t-closeness")) continue;
            node = attributes.getNamedItem("t");
            t = node.getNodeValue();
            break;
        }
        return t;
    }

    private static String getClouds(Document document) {
        String clouds = null;
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String protection = (node = attributes.getNamedItem("protection")).getNodeValue();
            if (!protection.equalsIgnoreCase("splitting")) continue;
            node = attributes.getNamedItem("clouds");
            clouds = node.getNodeValue();
            break;
        }
        return clouds;
    }

    private static String getIdKey(Document document) {
        String idKey = null;
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String protection = (node = attributes.getNamedItem("protection")).getNodeValue();
            if (!protection.equalsIgnoreCase("encryption")) continue;
            node = attributes.getNamedItem("id_key");
            idKey = node.getNodeValue();
            break;
        }
        return idKey;
    }

    private static String getRadius(Document document) {
        String radius = null;
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String protection = (node = attributes.getNamedItem("protection")).getNodeValue();
            if (!protection.equalsIgnoreCase("coarsening")) continue;
            node = attributes.getNamedItem("radius");
            radius = node.getNodeValue();
            break;
        }
        return radius;
    }

    private static String getCoarseningType(Document document) {
        String type = null;
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String protection = (node = attributes.getNamedItem("protection")).getNodeValue();
            if (!protection.equalsIgnoreCase("coarsening")) continue;
            node = attributes.getNamedItem("coarsening_type");
            type = node.getNodeValue();
            break;
        }
        return type;
    }

    private static String getCoarseningK(Document document) {
        String k = null;
        NodeList nodeList = document.getElementsByTagName("attribute_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String protection = (node = attributes.getNamedItem("protection")).getNodeValue();
            if (!protection.equalsIgnoreCase("coarsening")) continue;
            node = attributes.getNamedItem("k");
            k = node.getNodeValue();
            break;
        }
        return k;
    }

    private static ArrayList<String> getAtributeNames(Document document) {
        ArrayList<String> names = new ArrayList<String>();
        NodeList nodeList = document.getElementsByTagName("attribute");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            node = attributes.getNamedItem("name");
            String name = node.getNodeValue();
            names.add(name);
        }
        return names;
    }

    private static ArrayList<String> getAtributeTypes(Document document) {
        ArrayList<String> attrTypes = new ArrayList<String>();
        NodeList nodeList = document.getElementsByTagName("attribute");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            node = attributes.getNamedItem("attribute_type");
            String attrType = node.getNodeValue();
            attrTypes.add(attrType);
        }
        return attrTypes;
    }

    private static ArrayList<String> getAttributeDataTypes(Document document) {
        ArrayList<String> attrTypes = new ArrayList<String>();
        NodeList nodeList = document.getElementsByTagName("attribute");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if ((node = attributes.getNamedItem("data_type")) == null) {
                attrTypes.add("");
                continue;
            }
            String attrType = node.getNodeValue();
            attrTypes.add(attrType);
        }
        return attrTypes;
    }

    public static ArrayList<Record> createRecords(String data) {
        LOGGER.trace("Loading records...");
        ArrayList<Record> records = new ArrayList<Record>();
        String[] recordsStr = data.split(Record.recordSeparator);
        int id = 0;
        for (int i = 0; i < recordsStr.length; ++i) {
            String[] strTemp = recordsStr[i].split(Record.attributeSeparator);
            Record record = new Record(id);
            ++id;
            for (int j = 0; j < Record.numAttr; ++j) {
                record.attrValues[j] = strTemp[j];
            }
            records.add(record);
        }
        LOGGER.debug("Records loaded: {}", (Object)records.size());
        return records;
    }

    public static ArrayList<Record> createRecords(String[][] data) {
        LOGGER.trace("Loading records...");
        ArrayList<Record> records = new ArrayList<Record>();
        Record record = null;
        int id = 0;
        for (int i = 0; i < data.length; ++i) {
            record = new Record(id);
            ++id;
            for (int j = 0; j < data[i].length; ++j) {
                record.attrValues[j] = data[i][j];
            }
            records.add(record);
        }
        LOGGER.debug("Records loaded: {}", (Object)records.size());
        return records;
    }

    public static String[][] createMatrixStringFromRecords(ArrayList<Record> records) {
        LOGGER.trace("Converting {} records to String matrix", (Object)records.size());
        String[][] data = new String[records.size()][];
        for (int i = 0; i < records.size(); ++i) {
            Record record = records.get(i);
            data[i] = record.toVectorString();
        }
        LOGGER.debug("{} records converted to String matrix", (Object)data.length);
        return data;
    }

    public static ArrayList<Record> readFile(String fileStr, String fileProperties) {
        String linea;
        LOGGER.trace("Loading records...");
        ArrayList<Record> records = new ArrayList<Record>();
        Functions.readPropertiesFromFile(fileProperties);
        FileReader2 file = new FileReader2(fileStr);
        if (Record.header) {
            String string = file.readLine();
        }
        int id = 0;
        while ((linea = file.readLine()) != null) {
            String[] strTemp = linea.split(Record.attributeSeparator);
            Record record = new Record(id);
            ++id;
            for (int i = 0; i < Record.numAttr; ++i) {
                record.attrValues[i] = strTemp[i];
            }
            records.add(record);
        }
        file.closeFile();
        LOGGER.debug("Records loaded: {}", (Object)records.size());
        return records;
    }

    @Deprecated
    public static void writeFile(ArrayList<ArrayList<Record>> data) {
        for (int i = 0; i < data.size(); ++i) {
            int cont = 0;
            if (Record.header) {
                Functions.addCabecera(data.get(i));
                cont = -1;
            }
            String fileName = "data_clarus_anom_" + (i + 1) + ".txt";
            File file = new File(fileName);
            try {
                FileWriter fw = new FileWriter(file);
                BufferedWriter bw = new BufferedWriter(fw);
                for (Record r : data.get(i)) {
                    bw.write(r.toString());
                    bw.newLine();
                    ++cont;
                }
                bw.close();
                fw.close();
                System.out.println("Records saved: " + cont);
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addCabecera(ArrayList<Record> lista) {
        Record record = new Record(0);
        for (int i = 0; i < Record.listNames.size(); ++i) {
            record.attrValues[i] = Record.listNames.get(i);
        }
        lista.add(0, record);
    }
}

