/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

import eu.clarussecure.dataoperations.anonymization.RecordQ;
import java.util.ArrayList;

public class Distances {
    static double[] typicalDev;

    public static double euclideanDistNorm(RecordQ c1, RecordQ c2) {
        double dis = 0.0;
        double partial1 = 0.0;
        double partial = 0.0;
        for (int i = 0; i < RecordQ.numAttr; ++i) {
            String attrType = RecordQ.listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("quasi_identifier")) continue;
            String dataType = RecordQ.listDataTypes.get(i);
            if (dataType.equalsIgnoreCase("numeric_discrete") || dataType.equalsIgnoreCase("numeric_continuous") || dataType.equalsIgnoreCase("date")) {
                double cn1 = Double.parseDouble(c1.attrValues[i]);
                double cn2 = Double.parseDouble(c2.attrValues[i]);
                partial1 = (cn1 - cn2) / typicalDev[i];
            }
            if (dataType.equalsIgnoreCase("categoric")) {
                if (c1.attrValues[i].equalsIgnoreCase(c2.attrValues[i])) {
                    partial1 = 0.0;
                } else {
                    partial = 1.0;
                }
            }
            partial += partial1 * partial1;
        }
        dis = Math.sqrt(partial);
        return dis;
    }

    public static void calculateTypicalDeviationsNumeric(ArrayList<RecordQ> data) {
        int numAttr = data.get((int)0).attrValues.length;
        typicalDev = new double[numAttr];
        double[] max = new double[numAttr];
        double[] min = new double[numAttr];
        for (int i = 0; i < numAttr; ++i) {
            double dev;
            if (RecordQ.listDataTypes.get(i).equalsIgnoreCase("categoric") || RecordQ.listDataTypes.get(i).equalsIgnoreCase("categoric_ordinal")) {
                dev = 0.5;
            } else {
                double[] var = new double[data.size()];
                max[i] = Double.parseDouble(data.get((int)0).attrValues[i]);
                min[i] = Double.parseDouble(data.get((int)0).attrValues[i]);
                for (int j = 0; j < data.size(); ++j) {
                    var[j] = Double.parseDouble(data.get((int)j).attrValues[i]);
                    if (var[j] > max[i]) {
                        max[i] = var[j];
                    }
                    if (!(var[j] < min[i])) continue;
                    min[i] = var[j];
                }
                dev = Distances.calculateTypicalDeviation(var);
            }
            Distances.typicalDev[i] = dev;
        }
    }

    public static void calculateTypicalDeviationsNumericWithConfidential(ArrayList<RecordQ> data) {
        int numAttr = data.get((int)0).attrValues.length - 1;
        typicalDev = new double[numAttr];
        double[] max = new double[numAttr];
        double[] min = new double[numAttr];
        for (int i = 0; i < numAttr; ++i) {
            double dev;
            if (RecordQ.listDataTypes.get(i).equalsIgnoreCase("categoric") || RecordQ.listDataTypes.get(i).equalsIgnoreCase("categoric_ordinal")) {
                dev = 0.5;
            } else {
                double[] var = new double[data.size()];
                max[i] = Double.parseDouble(data.get((int)0).attrValues[i]);
                min[i] = Double.parseDouble(data.get((int)0).attrValues[i]);
                for (int j = 0; j < data.size(); ++j) {
                    var[j] = Double.parseDouble(data.get((int)j).attrValues[i]);
                    if (var[j] > max[i]) {
                        max[i] = var[j];
                    }
                    if (!(var[j] < min[i])) continue;
                    min[i] = var[j];
                }
                dev = Distances.calculateTypicalDeviation(var);
            }
            Distances.typicalDev[i] = dev;
        }
    }

    private static double calculateTypicalDeviation(double[] var) {
        int i;
        double medianVar = 0.0;
        for (i = 0; i < var.length; ++i) {
            medianVar += var[i];
        }
        medianVar /= (double)var.length;
        double tipicalDev = 0.0;
        for (i = 0; i < var.length; ++i) {
            double partial = var[i] - medianVar;
            partial *= partial;
            tipicalDev += partial;
        }
        tipicalDev /= (double)(var.length - 1);
        tipicalDev = Math.sqrt(tipicalDev);
        return tipicalDev;
    }
}

