/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

public class CoordinateS {
    double latitude;
    double longitude;
    int id;
    int srid;

    public CoordinateS(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public CoordinateS(double latitude, double longitude, int id) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public CoordinateS(double latitude, double longitude, int id, int srid) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.id = id;
        this.srid = srid;
    }

    public void setLocation(double lat, double lon) {
        this.latitude = lat;
        this.longitude = lon;
    }

    public double distanceSq(CoordinateS coordinate) {
        double x = coordinate.latitude - this.latitude;
        double y = coordinate.longitude - this.longitude;
        return x * x + y * y;
    }

    public double distanciaHaversine(CoordinateS coordinate) {
        double R = 6372800.0;
        double dLat = Math.toRadians(this.latitude - coordinate.latitude);
        double dLon = Math.toRadians(this.longitude - coordinate.longitude);
        double lat1 = Math.toRadians(this.latitude);
        double lat2 = Math.toRadians(coordinate.latitude);
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.pow(Math.sin(dLon / 2.0), 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return 6372800.0 * c;
    }

    public double distanciaFast(CoordinateS coordinate) {
        double lat2 = coordinate.latitude;
        double lon2 = coordinate.longitude;
        double deglen = 110.25;
        double x = this.latitude - lat2;
        double y = (this.longitude - lon2) * Math.cos(lat2);
        double dist = deglen * Math.sqrt(x * x + y * y);
        return dist *= 1000.0;
    }

    public String toString() {
        return this.latitude + "," + this.longitude;
    }
}

