/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

import eu.clarussecure.dataoperations.anonymization.Distances;
import eu.clarussecure.dataoperations.anonymization.RecordQ;
import java.util.Comparator;

public class ComparatorQuasi
implements Comparator<RecordQ> {
    static RecordQ zero;

    public static void setAttributeSortCriteria(RecordQ record) {
        zero = new RecordQ(0);
        for (int i = 0; i < RecordQ.numAttr; ++i) {
            String attrType = RecordQ.listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("quasi_identifier")) continue;
            String dataType = RecordQ.listDataTypes.get(i);
            if (dataType.equalsIgnoreCase("numeric_discrete") || dataType.equalsIgnoreCase("numeric_continuous") || dataType.equalsIgnoreCase("date")) {
                ComparatorQuasi.zero.attrValues[i] = "0";
            }
            if (!dataType.equalsIgnoreCase("categoric") && !dataType.equalsIgnoreCase("categoric_ordinal")) continue;
            ComparatorQuasi.zero.attrValues[i] = record.attrValues[i];
        }
    }

    @Override
    public int compare(RecordQ o1, RecordQ o2) {
        double dis2;
        double dis1 = Distances.euclideanDistNorm(o1, zero);
        if (dis1 > (dis2 = Distances.euclideanDistNorm(o2, zero))) {
            return 1;
        }
        if (dis1 < dis2) {
            return -1;
        }
        return 0;
    }
}

