/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

import eu.clarussecure.dataoperations.anonymization.CoordinateS;
import java.util.ArrayList;

public class ClusterPoints {
    private ArrayList<CoordinateS> points = new ArrayList();
    private CoordinateS centroid = null;

    public void add(CoordinateS point) {
        this.points.add(point);
    }

    public void clear() {
        this.points.clear();
    }

    public ArrayList<CoordinateS> getPoints() {
        return this.points;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public CoordinateS getCentroid() {
        if (this.centroid == null) {
            this.calculateCentroid();
        }
        return this.centroid;
    }

    public CoordinateS calculateCentroid() {
        double y;
        double x;
        double maxY = -1.7976931348623157E308;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double minX = Double.MAX_VALUE;
        this.centroid = new CoordinateS(maxX, maxY);
        for (CoordinateS p : this.points) {
            x = p.latitude;
            y = p.longitude;
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (x < minX) {
                minX = x;
            }
            if (!(y < minY)) continue;
            minY = y;
        }
        x = (maxX + minX) / 2.0;
        y = (maxY + minY) / 2.0;
        this.centroid.setLocation(x, y);
        return this.centroid;
    }

    public String toString() {
        String s = "";
        for (CoordinateS c : this.points) {
            s = s + c + "\n";
        }
        s = s + "c:" + this.centroid;
        return s;
    }
}

