/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

import eu.clarussecure.dataoperations.anonymization.RecordQ;
import java.util.ArrayList;
import java.util.HashMap;

public class Cluster {
    private ArrayList<RecordQ> elements = new ArrayList();
    private RecordQ centroid = null;

    public void add(RecordQ reg) {
        this.elements.add(reg);
    }

    public void clear() {
        this.elements.clear();
    }

    public ArrayList<RecordQ> getElements() {
        return this.elements;
    }

    public int getNumReg() {
        return this.elements.size();
    }

    public RecordQ getCentroid() {
        if (this.centroid == null) {
            this.calculateCentroid();
        }
        return this.centroid;
    }

    public void calculateCentroid() {
        this.centroid = new RecordQ(0);
        for (int i = 0; i < RecordQ.numAttr; ++i) {
            String moda;
            long media;
            String attrType = RecordQ.listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("quasi_identifier")) continue;
            String dataType = RecordQ.listDataTypes.get(i);
            if (dataType.equalsIgnoreCase("numeric_discrete") || dataType.equalsIgnoreCase("date")) {
                media = this.calculateMedia(i);
                this.centroid.attrValues[i] = String.valueOf(media);
                continue;
            }
            if (dataType.equalsIgnoreCase("numeric_continuous")) {
                media = this.calculateMediaDouble(i);
                this.centroid.attrValues[i] = String.valueOf(media);
                continue;
            }
            this.centroid.attrValues[i] = moda = this.calculateModa(i);
        }
    }

    private long calculateMedia(int attr) {
        long media = 0L;
        for (RecordQ reg : this.elements) {
            String valor = reg.attrValues[attr];
            media += Long.parseLong(valor);
        }
        return media /= (long)this.elements.size();
    }

    private long calculateMediaDouble(int attr) {
        double media = 0.0;
        for (RecordQ reg : this.elements) {
            String valor = reg.attrValues[attr];
            media += (double)Long.parseLong(valor);
        }
        return (long)(media /= (double)this.elements.size());
    }

    private String calculateModa(int attr) {
        Integer v;
        HashMap<String, Integer> control = new HashMap<String, Integer>();
        for (RecordQ reg : this.elements) {
            String valor = reg.attrValues[attr];
            v = (Integer)control.get(valor);
            if (v == null) {
                control.put(valor, 1);
                continue;
            }
            Integer n = v;
            Integer n2 = v = Integer.valueOf(v + 1);
            control.put(valor, v);
        }
        Integer maxV = 0;
        String moda = "";
        for (String s : control.keySet()) {
            v = (Integer)control.get(s);
            if (v <= maxV) continue;
            moda = s;
            maxV = v;
        }
        return moda;
    }
}

