/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.DataOperationCommand;
import eu.clarussecure.dataoperations.SEmodule.BuildIndex;
import eu.clarussecure.dataoperations.SEmodule.Constants;
import eu.clarussecure.dataoperations.SEmodule.Encryptor;
import eu.clarussecure.dataoperations.SEmodule.KeyManagementUtils;
import eu.clarussecure.dataoperations.SEmodule.Permutation;
import eu.clarussecure.dataoperations.SEmodule.RangeUtils;
import eu.clarussecure.dataoperations.SEmodule.SearchableEncryptionCommand;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;

public class Store {
    private static SecretKey encryption_Key;
    private static SecretKey prfKey;
    private static SecretKey permKey;
    private static String[][] contents;
    private static String[] attributes;
    private static String[][] encrypted_content;
    private static String[] encrypted_attributes;
    private static String[] extraProtectedAttributeNames;
    private static Map<String, String> mapping;
    private static ArrayList<Object> index;
    private static Logger logger;
    public static Map<String, String> num_Attr;
    public static Map<String, String> ranges;

    public static final List<DataOperationCommand> store_with_SE(String[] attributeNames, String[][] data_contents, int[] indexes) throws Exception {
        SecretKey newSK;
        int i;
        ArrayList<DataOperationCommand> myList = new ArrayList<DataOperationCommand>();
        SearchableEncryptionCommand SE_post_query = new SearchableEncryptionCommand();
        logger.info((Object)"Step 01: Generate Keying material");
        SecretKey[] keys = new SecretKey[3];
        keys = KeyManagementUtils.loadSecretKeys();
        encryption_Key = keys[0];
        prfKey = keys[1];
        permKey = keys[2];
        logger.info((Object)"\nStep 02: Shuffling rows");
        int[] permuted = new int[data_contents.length];
        permuted = Permutation.permute_array(data_contents.length);
        contents = new String[data_contents.length][attributeNames.length];
        for (int i2 = 0; i2 < data_contents.length; ++i2) {
            Store.contents[i2] = (String[])data_contents[permuted[i2]].clone();
        }
        attributes = attributeNames;
        System.out.println("\nStep 03: Range configuration");
        int num_attr = RangeUtils.checkContent(attributes, contents);
        if (num_attr > 0) {
            System.out.println(num_attr + " numerical attributes found!");
            RangeUtils.askUserForRangeFeature();
        } else {
            System.out.println("Your database does not contain numerical values. No range configuration.");
        }
        if (!ranges.isEmpty()) {
            System.out.println("\nStoring range configuration in a file");
            Map[] config = new Map[]{num_Attr, ranges};
            Store.storeConfig(config);
            System.out.println("[OK] File created");
            System.out.println("\n\nStep 04: Update the database with the range configuration");
            String[][] updatedDB = RangeUtils.updateDB(attributes, contents);
            String[] attributes_with_range = new String[updatedDB[0].length];
            attributes_with_range = (String[])updatedDB[0].clone();
            String[][] contents_with_range = new String[updatedDB.length - 1][updatedDB[0].length];
            for (i = 0; i < updatedDB.length - 1; ++i) {
                contents_with_range[i] = (String[])updatedDB[i + 1].clone();
            }
            System.out.println("\nStep 05: Generate secure index");
            index = BuildIndex.buildIndex(attributes_with_range, contents_with_range, prfKey, permKey);
        } else {
            System.out.println("\nStep 04: Generate secure index");
            index = BuildIndex.buildIndex(attributes, contents, prfKey, permKey);
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream byte_index = new ObjectOutputStream(byteOut);
        byte_index.writeObject(index);
        ByteArrayInputStream is_index = new ByteArrayInputStream(byteOut.toByteArray());
        byte_index.close();
        byteOut.close();
        encrypted_attributes = new String[attributes.length + 1];
        encrypted_content = new String[contents.length][contents[0].length + 1];
        if (!ranges.isEmpty()) {
            System.out.println("\n\nStep 06: Encrypt attributes and data0m");
        } else {
            System.out.println("\n\nStep 05: Encrypt attributes and data");
        }
        for (i = 0; i < attributeNames.length; ++i) {
            newSK = KeyManagementUtils.hashAESKey(encryption_Key, Integer.toString(indexes[i] + 1));
            Store.encrypted_attributes[i] = Encryptor.encrypt(attributes[i], newSK, true);
        }
        Store.encrypted_attributes[attributeNames.length] = "rowID";
        for (i = 0; i < contents.length; ++i) {
            for (int j = 0; j < contents[0].length; ++j) {
                newSK = KeyManagementUtils.hashAESKey(encryption_Key, Integer.toString(i + 1 + indexes[j]));
                Store.encrypted_content[i][j] = Encryptor.encrypt(contents[i][j], newSK);
            }
            Store.encrypted_content[i][Store.contents[0].length] = Integer.toString(i + 1);
        }
        logger.info((Object)("Plain content:\n" + Arrays.deepToString((Object[])contents).replaceAll("],", "]," + System.getProperty("line.separator")) + "\n"));
        logger.info((Object)(encrypted_content.length + " rows have been encrypted\n"));
        SE_post_query.setAttributeNames(attributeNames);
        SE_post_query.setProtectedAttributeNames(encrypted_attributes);
        SE_post_query.setExtraProtectedAttributeNames(extraProtectedAttributeNames);
        InputStream[] extraBinaryContent = new InputStream[]{is_index};
        SE_post_query.setExtraBinaryContent(extraBinaryContent);
        for (int i3 = 0; i3 < encrypted_attributes.length - 1; ++i3) {
            mapping.put(attributes[i3], encrypted_attributes[i3]);
        }
        SE_post_query.setMapping(mapping);
        SE_post_query.setProtectedContents(encrypted_content);
        myList.add(SE_post_query);
        return myList;
    }

    public static ArrayList<Object> getIndex() {
        return index;
    }

    public static void storeConfig(Map[] config) throws FileNotFoundException, IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(Constants.tableName + ".config"));
        out.writeObject(config);
        out.close();
    }

    static {
        extraProtectedAttributeNames = new String[]{Constants.tableName + "/" + Constants.indexName};
        mapping = new HashMap<String, String>();
        logger = Logger.getLogger(Store.class);
        num_Attr = new HashMap<String, String>();
        ranges = new HashMap<String, String>();
    }
}

