/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.AttributeNamesUtilities;
import eu.clarussecure.dataoperations.Criteria;
import eu.clarussecure.dataoperations.DataOperation;
import eu.clarussecure.dataoperations.DataOperationCommand;
import eu.clarussecure.dataoperations.DataOperationResult;
import eu.clarussecure.dataoperations.SEmodule.Encryptor;
import eu.clarussecure.dataoperations.SEmodule.KeyManagementUtils;
import eu.clarussecure.dataoperations.SEmodule.Query;
import eu.clarussecure.dataoperations.SEmodule.Retrieve;
import eu.clarussecure.dataoperations.SEmodule.SearchableEncryptionCommand;
import eu.clarussecure.dataoperations.SEmodule.SearchableEncryptionResponse;
import eu.clarussecure.dataoperations.SEmodule.Store;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SearchableEncryptionModule
implements DataOperation {
    private static Logger logger = Logger.getLogger(SearchableEncryptionModule.class);
    private Map<String, Pattern> attributePatterns = new HashMap<String, Pattern>();
    private Map<String, String> attributeTypes = new HashMap<String, String>();
    private Map<String, String> dataTypes = new HashMap<String, String>();
    private Map<String, Integer> attributeIndexes = new HashMap<String, Integer>();
    private Map<String, String> typesProtection = new HashMap<String, String>();
    private Map<String, String> typesDataIDs = new HashMap<String, String>();

    public SearchableEncryptionModule(Document policy) {
        NamedNodeMap attributes;
        Node node;
        int i;
        NodeList nodes = policy.getElementsByTagName("attribute");
        for (i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            attributes = node.getAttributes();
            String attributeName = attributes.getNamedItem("name").getNodeValue();
            String fqAttributeName = AttributeNamesUtilities.fullyQualified((String)attributeName);
            Pattern attributePattern = Pattern.compile(AttributeNamesUtilities.escapeRegex((String)fqAttributeName));
            String attributeType = attributes.getNamedItem("attribute_type").getNodeValue();
            String dataType = attributes.getNamedItem("data_type").getNodeValue();
            this.attributePatterns.put(fqAttributeName, attributePattern);
            this.attributeTypes.put(fqAttributeName, attributeType);
            this.dataTypes.put(fqAttributeName, dataType);
            this.attributeIndexes.put(fqAttributeName, i);
        }
        nodes = policy.getElementsByTagName("attribute_type");
        for (i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            attributes = node.getAttributes();
            String attributeType = attributes.getNamedItem("type").getNodeValue();
            String typeProtection = attributes.getNamedItem("protection").getNodeValue();
            this.typesProtection.put(attributeType, typeProtection.toLowerCase());
            if (!typeProtection.equals("encryption") && !typeProtection.equals("searchable")) continue;
            String dataID = attributes.getNamedItem("id_key").getNodeValue();
            this.typesDataIDs.put(attributeType, dataID);
        }
        String ksName = "clarus_keystore";
        if (!ksName.equals(System.getProperty("java.home") + "/lib/security/jssecacerts")) {
            try {
                Files.deleteIfExists(FileSystems.getDefault().getPath(ksName, new String[0]));
                KeyManagementUtils.procedureKeyGen();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                e.printStackTrace();
            }
        }
    }

    public List<DataOperationCommand> post(String[] attributeNames, String[][] contents) {
        List allFqAttributeNames = Arrays.stream(attributeNames).map(an -> this.attributePatterns.entrySet().stream().filter(e -> ((Pattern)e.getValue()).matcher((CharSequence)an).matches()).findFirst().map(Map.Entry::getKey).orElse(null)).collect(Collectors.toList());
        List encryptedAttributeFlags = allFqAttributeNames.stream().map(fqan -> this.attributeTypes.get(fqan)).map(type -> this.typesProtection.get(type)).map(typeProtection -> Stream.of("encryption", "searchable").anyMatch(protection -> protection.equals(typeProtection))).collect(Collectors.toList());
        List attributeNamesToProcess = IntStream.range(0, attributeNames.length).filter(i -> (Boolean)encryptedAttributeFlags.get(i)).mapToObj(i -> attributeNames[i]).collect(Collectors.toList());
        List encryptedAttributeIndexes = Arrays.stream(attributeNames).map(an -> attributeNamesToProcess.indexOf(an)).collect(Collectors.toList());
        String[] attributeNamesToEncrypt = (String[])attributeNamesToProcess.stream().map(an -> an.split("/")).map(parts -> parts[((String[])parts).length - 1]).toArray(String[]::new);
        String[][] contentToEncrypt = (String[][])Arrays.stream(contents).map(row -> (String[])IntStream.range(0, ((String[])row).length).filter(c -> (Integer)encryptedAttributeIndexes.get(c) != -1).mapToObj(c -> row[c]).map(v -> v == null ? "clarus_null" : v).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        int[] indexes = IntStream.range(0, allFqAttributeNames.size()).filter(i -> (Boolean)encryptedAttributeFlags.get(i)).mapToObj(i -> (String)allFqAttributeNames.get(i)).map(fqan -> this.attributeIndexes.get(fqan)).mapToInt(Integer::intValue).toArray();
        List<DataOperationCommand> SEcommand = null;
        if (attributeNamesToEncrypt.length > 0) {
            try {
                SEcommand = Store.store_with_SE(attributeNamesToEncrypt, contentToEncrypt, indexes);
            }
            catch (Exception e) {
                logger.info((Object)"[FAILURE]: Searchable Encryption post");
                logger.info((Object)e);
                System.exit(1);
            }
        } else {
            SEcommand = Collections.singletonList(new SearchableEncryptionCommand());
        }
        SearchableEncryptionCommand postQuery = (SearchableEncryptionCommand)((Object)SearchableEncryptionCommand.class.cast((Object)SEcommand.get(0)));
        String[] clearAttributeNames = new String[encryptedAttributeFlags.size() + (attributeNamesToEncrypt.length > 0 ? 1 : 0)];
        String[] protectedAttributeNames = new String[encryptedAttributeFlags.size() + (attributeNamesToEncrypt.length > 0 ? 1 : 0)];
        String[][] protectedContents = new String[contents.length][protectedAttributeNames.length];
        HashMap<String, String> mapping = new HashMap<String, String>();
        String[] parts2 = null;
        for (int i2 = 0; i2 < attributeNames.length; ++i2) {
            clearAttributeNames[i2] = attributeNames[i2];
            if (((Boolean)encryptedAttributeFlags.get(i2)).booleanValue()) {
                parts2 = clearAttributeNames[i2].split("/");
                parts2[parts2.length - 1] = postQuery.getProtectedAttributeNames()[(Integer)encryptedAttributeIndexes.get(i2)];
                protectedAttributeNames[i2] = this.mergeAttributeName(parts2);
            } else {
                protectedAttributeNames[i2] = clearAttributeNames[i2];
            }
            mapping.put(clearAttributeNames[i2], protectedAttributeNames[i2]);
            for (int r = 0; r < protectedContents.length; ++r) {
                protectedContents[r][i2] = (Boolean)encryptedAttributeFlags.get(i2) != false ? postQuery.getProtectedContents()[r][(Integer)encryptedAttributeIndexes.get(i2)] : contents[r][i2];
            }
        }
        if (attributeNamesToEncrypt.length > 0) {
            parts2[parts2.length - 1] = "?attribute1?";
            clearAttributeNames[clearAttributeNames.length - 1] = this.mergeAttributeName(parts2);
            parts2[parts2.length - 1] = postQuery.getProtectedAttributeNames()[postQuery.getProtectedAttributeNames().length - 1];
            protectedAttributeNames[protectedAttributeNames.length - 1] = this.mergeAttributeName(parts2);
            for (int r = 0; r < protectedContents.length; ++r) {
                protectedContents[r][protectedAttributeNames.length - 1] = postQuery.getProtectedContents()[r][postQuery.getProtectedAttributeNames().length - 1];
            }
            mapping.put(clearAttributeNames[clearAttributeNames.length - 1], protectedAttributeNames[protectedAttributeNames.length - 1]);
        }
        postQuery.setAttributeNames(clearAttributeNames);
        postQuery.setProtectedAttributeNames(protectedAttributeNames);
        postQuery.setProtectedContents(protectedContents);
        postQuery.setMapping(mapping);
        return SEcommand;
    }

    public List<DataOperationCommand> get(String[] attributeNames, Criteria[] criteria) {
        List allFqAttributeNames = Arrays.stream(attributeNames).map(an -> this.attributePatterns.entrySet().stream().filter(e -> ((Pattern)e.getValue()).matcher((CharSequence)an).matches()).findFirst().map(Map.Entry::getKey).orElse(null)).collect(Collectors.toList());
        List encryptedAttributeFlags = allFqAttributeNames.stream().map(fqan -> this.attributeTypes.get(fqan)).map(type -> this.typesProtection.get(type)).map(typeProtection -> Stream.of("encryption", "searchable").anyMatch(protection -> protection.equals(typeProtection))).collect(Collectors.toList());
        List attributeNamesToProcess = IntStream.range(0, attributeNames.length).filter(i -> (Boolean)encryptedAttributeFlags.get(i)).mapToObj(i -> attributeNames[i]).collect(Collectors.toList());
        List encryptedAttributeIndexes = Arrays.stream(attributeNames).map(an -> attributeNamesToProcess.indexOf(an)).collect(Collectors.toList());
        String[] attributeNamesToEncrypt = (String[])attributeNamesToProcess.stream().map(an -> an.split("/")).map(parts -> parts[((String[])parts).length - 1]).toArray(String[]::new);
        int[] indexes = IntStream.range(0, allFqAttributeNames.size()).filter(i -> (Boolean)encryptedAttributeFlags.get(i)).mapToObj(i -> (String)allFqAttributeNames.get(i)).map(fqan -> this.attributeIndexes.get(fqan)).mapToInt(Integer::intValue).toArray();
        List allFqCriteriaAttributeNames = Arrays.stream(criteria).map(Criteria::getAttributeName).map(an -> this.attributePatterns.entrySet().stream().filter(e -> ((Pattern)e.getValue()).matcher((CharSequence)an).matches()).findFirst().map(Map.Entry::getKey).orElse(null)).collect(Collectors.toList());
        List encryptedCriteriaFlags = IntStream.range(0, criteria.length).mapToObj(i -> (criteria[i].getOperator().equals("=") || criteria[i].getOperator().equals(">") || criteria[i].getOperator().equals(">=") || criteria[i].getOperator().equals("<") || criteria[i].getOperator().equals("<=")) && Stream.of("encryption", "searchable").anyMatch(protection -> protection.equals(this.typesProtection.get(this.attributeTypes.get(allFqCriteriaAttributeNames.get(i)))))).collect(Collectors.toList());
        List criteriaToProcess = IntStream.range(0, criteria.length).filter(i -> (Boolean)encryptedCriteriaFlags.get(i)).mapToObj(i -> criteria[i]).collect(Collectors.toList());
        List encryptedCriteriaIndexes = Arrays.stream(criteria).map(c -> criteriaToProcess.indexOf(c)).collect(Collectors.toList());
        Criteria[] criteriaToEncrypt = (Criteria[])criteriaToProcess.stream().map(c -> {
            String[] parts = c.getAttributeName().split("/");
            return new Criteria(parts[parts.length - 1], c.getOperator(), c.getValue());
        }).toArray(Criteria[]::new);
        List<DataOperationCommand> SEquery = null;
        if (attributeNamesToEncrypt.length > 0) {
            try {
                SEquery = Query.search_with_SE(attributeNamesToEncrypt, criteriaToEncrypt, indexes);
            }
            catch (Exception e) {
                System.exit(1);
            }
        } else {
            SEquery = Collections.singletonList(new SearchableEncryptionCommand());
        }
        SearchableEncryptionCommand searchQuery = (SearchableEncryptionCommand)((Object)SearchableEncryptionCommand.class.cast((Object)SEquery.get(0)));
        String[] clearAttributeNames = new String[encryptedAttributeFlags.size() + (attributeNamesToEncrypt.length > 0 ? 1 : 0)];
        String[] protectedAttributeNames = new String[encryptedAttributeFlags.size() + (attributeNamesToEncrypt.length > 0 ? 1 : 0)];
        HashMap<String, String> mapping = new HashMap<String, String>();
        String[] parts2 = null;
        for (int i2 = 0; i2 < attributeNames.length; ++i2) {
            clearAttributeNames[i2] = attributeNames[i2];
            if (((Boolean)encryptedAttributeFlags.get(i2)).booleanValue()) {
                parts2 = clearAttributeNames[i2].split("/");
                parts2[parts2.length - 1] = searchQuery.getProtectedAttributeNames()[(Integer)encryptedAttributeIndexes.get(i2)];
                protectedAttributeNames[i2] = this.mergeAttributeName(parts2);
            } else {
                protectedAttributeNames[i2] = clearAttributeNames[i2];
            }
            mapping.put(clearAttributeNames[i2], protectedAttributeNames[i2]);
        }
        if (attributeNamesToEncrypt.length > 0) {
            parts2[parts2.length - 1] = "?attribute1?";
            clearAttributeNames[clearAttributeNames.length - 1] = this.mergeAttributeName(parts2);
            parts2[parts2.length - 1] = searchQuery.getProtectedAttributeNames()[searchQuery.getProtectedAttributeNames().length - 1];
            protectedAttributeNames[protectedAttributeNames.length - 1] = this.mergeAttributeName(parts2);
            mapping.put(clearAttributeNames[clearAttributeNames.length - 1], protectedAttributeNames[protectedAttributeNames.length - 1]);
        }
        Criteria[] protectedCriteria = new Criteria[encryptedCriteriaFlags.size()];
        for (int i3 = 0; i3 < protectedCriteria.length; ++i3) {
            if (((Boolean)encryptedCriteriaFlags.get(i3)).booleanValue()) {
                parts2 = criteria[i3].getAttributeName().split("/");
                Criteria newCriteria = searchQuery.getCriteria()[(Integer)encryptedCriteriaIndexes.get(i3)];
                parts2[parts2.length - 1] = newCriteria.getAttributeName();
                newCriteria.setAttributeName(this.mergeAttributeName(parts2));
                protectedCriteria[i3] = newCriteria;
                continue;
            }
            protectedCriteria[i3] = criteria[i3];
        }
        searchQuery.setAttributeNames(clearAttributeNames);
        searchQuery.setProtectedAttributeNames(protectedAttributeNames);
        searchQuery.setMapping(mapping);
        searchQuery.setCriteria(protectedCriteria);
        return SEquery;
    }

    public List<DataOperationResult> get(List<DataOperationCommand> promise, List<String[][]> contents) {
        String[] encryptedAttributeNames = promise.get(0).getProtectedAttributeNames();
        Map mapping = promise.get(0).getMapping();
        String[][] encryptedContents = contents.get(0);
        List encryptedAttributeFlags = Arrays.stream(encryptedAttributeNames).map(ean -> mapping.containsValue(ean) && !mapping.containsKey(ean)).collect(Collectors.toList());
        List encryptedAttributeNamesToProcess = IntStream.range(0, encryptedAttributeFlags.size()).filter(i -> (Boolean)encryptedAttributeFlags.get(i)).mapToObj(i -> encryptedAttributeNames[i]).collect(Collectors.toList());
        List encryptedAttributeIndexes = Arrays.stream(encryptedAttributeNames).map(an -> encryptedAttributeNamesToProcess.indexOf(an)).collect(Collectors.toList());
        String[] attributeNamesToDecrypt = (String[])encryptedAttributeNamesToProcess.stream().map(an -> an.split("/")).map(parts -> parts[((String[])parts).length - 1]).toArray(String[]::new);
        String[][] contentToDecrypt = (String[][])Arrays.stream(encryptedContents).map(row -> (String[])IntStream.range(0, ((String[])row).length).filter(c -> (Integer)encryptedAttributeIndexes.get(c) != -1).mapToObj(c -> row[c]).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        int[] indexes = encryptedAttributeNamesToProcess.stream().map(ean -> mapping.entrySet().stream().filter(e -> ((String)e.getValue()).equals(ean)).map(Map.Entry::getKey).findFirst().filter(an -> !an.endsWith("?attribute1?")).map(an -> this.attributePatterns.entrySet().stream().filter(e -> ((Pattern)e.getValue()).matcher((CharSequence)an).matches()).findFirst().map(Map.Entry::getKey).orElse(null)).orElse(null)).filter(fqan -> fqan != null).map(fqan -> this.attributeIndexes.get(fqan)).mapToInt(Integer::intValue).toArray();
        List<SearchableEncryptionResponse> SEresult = null;
        if (attributeNamesToDecrypt.length > 0) {
            try {
                try {
                    SEresult = Retrieve.decrypt_result(attributeNamesToDecrypt, contentToDecrypt, indexes);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
                e.printStackTrace();
            }
        } else {
            SEresult = Collections.singletonList(new SearchableEncryptionResponse());
        }
        SearchableEncryptionResponse searchResponse = (SearchableEncryptionResponse)((Object)SearchableEncryptionResponse.class.cast((Object)SEresult.get(0)));
        String[] clearAttributeNames = new String[encryptedAttributeFlags.size() - 1];
        String[][] clearContents = new String[encryptedContents.length][encryptedAttributeFlags.size() - 1];
        for (int i2 = 0; i2 < clearAttributeNames.length; ++i2) {
            if (((Boolean)encryptedAttributeFlags.get(i2)).booleanValue()) {
                String[] parts2 = encryptedAttributeNames[i2].split("/");
                parts2[parts2.length - 1] = searchResponse.getAttributeNames()[(Integer)encryptedAttributeIndexes.get(i2)];
                clearAttributeNames[i2] = this.mergeAttributeName(parts2);
            } else {
                clearAttributeNames[i2] = encryptedAttributeNames[i2];
            }
            for (int r = 0; r < clearContents.length; ++r) {
                if (((Boolean)encryptedAttributeFlags.get(i2)).booleanValue()) {
                    clearContents[r][i2] = searchResponse.getContents()[r][(Integer)encryptedAttributeIndexes.get(i2)];
                    if (!"clarus_null".equals(clearContents[r][i2])) continue;
                    clearContents[r][i2] = null;
                    continue;
                }
                clearContents[r][i2] = encryptedContents[r][i2];
            }
        }
        searchResponse.setAttributeNames(clearAttributeNames);
        searchResponse.setContents(clearContents);
        return SEresult;
    }

    public List<Map<String, String>> head(String[] attributeNames) {
        String[] resolvedAttributes = AttributeNamesUtilities.resolveOperationAttributeNames((String[])attributeNames, new ArrayList<String>(this.attributeTypes.keySet()));
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashMap<String, String> se_mapping = new HashMap<String, String>();
        logger.info((Object)"Loading search keys");
        String ksName = "clarus_keystore";
        char[] ksPassword = KeyManagementUtils.askPassword(ksName);
        try {
            KeyStore myKS = KeyManagementUtils.loadKeyStore(ksName, ksPassword);
            boolean additionalAttribute = false;
            String[] parts = null;
            for (int i = 0; i < resolvedAttributes.length; ++i) {
                String resolvedAttributeName = resolvedAttributes[i];
                String fqAttributeName = this.attributePatterns.entrySet().stream().filter(e -> ((Pattern)e.getValue()).matcher(resolvedAttributeName).matches()).findFirst().map(Map.Entry::getKey).orElse(null);
                if (fqAttributeName == null) continue;
                String attributeType = this.attributeTypes.get(fqAttributeName);
                String typeProtection = this.typesProtection.get(attributeType);
                if (typeProtection.equals("encryption") || typeProtection.equals("searchable")) {
                    additionalAttribute = true;
                    String keyAlias = this.typesDataIDs.get(attributeType);
                    SecretKey encryption_Key = KeyManagementUtils.loadSecretKey(myKS, keyAlias, ksPassword);
                    int index = this.attributeIndexes.get(fqAttributeName);
                    SecretKey newSK = KeyManagementUtils.hashAESKey(encryption_Key, Integer.toString(index + 1));
                    parts = resolvedAttributeName.split("/");
                    parts[parts.length - 1] = Encryptor.encrypt(parts[parts.length - 1], newSK, true);
                    String encryptedAttributeName = this.mergeAttributeName(parts);
                    se_mapping.put(resolvedAttributeName, encryptedAttributeName);
                    continue;
                }
                se_mapping.put(resolvedAttributeName, resolvedAttributeName);
            }
            if (additionalAttribute) {
                parts[parts.length - 1] = "?attribute1?";
                String fqAttributeName = this.mergeAttributeName(parts);
                parts[parts.length - 1] = "rowID";
                String encryptedAttributeName = this.mergeAttributeName(parts);
                se_mapping.put(fqAttributeName, encryptedAttributeName);
            }
        }
        catch (Exception e2) {
            logger.info((Object)"[FAILURE]");
            e2.printStackTrace();
        }
        output.add(se_mapping);
        return output;
    }

    private String mergeAttributeName(String[] parts) {
        if (parts.length == 3) {
            return String.format("%s/%s/%s", parts[0], parts[1], parts[2]);
        }
        if (parts.length == 2) {
            return String.format("%s/%s", parts[0], parts[1]);
        }
        if (parts.length == 1) {
            return parts[0];
        }
        return null;
    }

    public List<DataOperationCommand> put(String[] attributeNames, Criteria[] criteria, String[][] contents) {
        return null;
    }

    public List<DataOperationCommand> delete(String[] attributeNames, Criteria[] criteria) {
        return null;
    }
}

