/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.DataOperationResult;
import eu.clarussecure.dataoperations.SEmodule.Encryptor;
import eu.clarussecure.dataoperations.SEmodule.KeyManagementUtils;
import eu.clarussecure.dataoperations.SEmodule.SearchableEncryptionResponse;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;

public class Retrieve {
    private static Logger logger = Logger.getLogger(Retrieve.class);

    public static List<DataOperationResult> decrypt_result(String[] encrypted_attribute_names, String[][] encrypted_retrieved_results, int[] indexes) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException, SQLException {
        SecretKey newSK;
        ArrayList<DataOperationResult> output = new ArrayList<DataOperationResult>();
        SearchableEncryptionResponse SE_search_response = new SearchableEncryptionResponse();
        String ksName = "clarus_keystore";
        char[] ksPassword = KeyManagementUtils.askPassword(ksName);
        KeyStore myKS = KeyManagementUtils.loadKeyStore(ksName, ksPassword);
        SecretKey encryption_Key = KeyManagementUtils.loadSecretKey(myKS, "encKey", ksPassword);
        String[] decrypted_attribute_names = new String[encrypted_attribute_names.length - 1];
        for (int i = 0; i < decrypted_attribute_names.length; ++i) {
            try {
                newSK = KeyManagementUtils.hashAESKey(encryption_Key, Integer.toString(indexes[i] + 1));
                decrypted_attribute_names[i] = Encryptor.decrypt(encrypted_attribute_names[i], newSK, true);
                continue;
            }
            catch (Exception e) {
                logger.info((Object)"Decryption failure");
                e.printStackTrace();
            }
        }
        String[][] decrypted_content = new String[encrypted_retrieved_results.length][encrypted_retrieved_results[0].length - 1];
        for (int i = 0; i < encrypted_retrieved_results.length; ++i) {
            for (int j = 0; j < encrypted_retrieved_results[0].length - 1; ++j) {
                int row_number = Integer.parseInt(encrypted_retrieved_results[i][encrypted_retrieved_results[0].length - 1]) - 1;
                try {
                    newSK = KeyManagementUtils.hashAESKey(encryption_Key, Integer.toString(row_number + indexes[j] + 1));
                    decrypted_content[i][j] = Encryptor.decrypt(encrypted_retrieved_results[i][j], newSK);
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)"Decryption failure");
                }
            }
        }
        SE_search_response.setContents(decrypted_content);
        SE_search_response.setAttributeNames(decrypted_attribute_names);
        output.add((DataOperationResult)SE_search_response);
        return output;
    }
}

