/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.Criteria;
import eu.clarussecure.dataoperations.DataOperationCommand;
import eu.clarussecure.dataoperations.SEmodule.Constants;
import eu.clarussecure.dataoperations.SEmodule.Encryptor;
import eu.clarussecure.dataoperations.SEmodule.KeyManagementUtils;
import eu.clarussecure.dataoperations.SEmodule.SearchableEncryptionCommand;
import eu.clarussecure.dataoperations.SEmodule.Store;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;

public class Query {
    private static Logger logger = Logger.getLogger(Query.class);

    static List<DataOperationCommand> search_with_SE(String[] attributeNames, Criteria[] criteria, int[] indexes) throws Exception {
        ArrayList<DataOperationCommand> myList = new ArrayList<DataOperationCommand>();
        SearchableEncryptionCommand SE_search_query = new SearchableEncryptionCommand();
        ArrayList<Criteria> myCriteria = new ArrayList<Criteria>();
        String[] trap = null;
        logger.info((Object)"Loading search keys");
        String ksName = "clarus_keystore";
        char[] ksPassword = KeyManagementUtils.askPassword(ksName);
        KeyStore myKS = KeyManagementUtils.loadKeyStore(ksName, ksPassword);
        SecretKey y_Key = KeyManagementUtils.loadSecretKey(myKS, "y_Key", ksPassword);
        SecretKey z_Key = KeyManagementUtils.loadSecretKey(myKS, "z_Key", ksPassword);
        SecretKey encryption_Key = KeyManagementUtils.loadSecretKey(myKS, "encKey", ksPassword);
        logger.info((Object)"\nGenerating trapdoors...\n");
        logger.info((Object)("Number of criteria = " + criteria.length));
        for (int tt = 0; tt < criteria.length; ++tt) {
            logger.info((Object)(criteria[tt].getAttributeName() + "" + criteria[tt].getOperator() + "" + criteria[tt].getValue()));
        }
        for (int i = 0; i < criteria.length; ++i) {
            if (criteria[i].getAttributeName() != null && criteria[i].getValue() != null) {
                String keyword;
                if (!Store.ranges.isEmpty() && Store.ranges.containsKey(criteria[i].getAttributeName()) && (criteria[i].getOperator() == ">=" || criteria[i].getOperator() == ">" || criteria[i].getOperator() == "<=" || criteria[i].getOperator() == "<")) {
                    Criteria fake;
                    Map<Object, Object> ListTrapdoorForRange = new HashMap();
                    myCriteria.add(new Criteria("", "(", ""));
                    if (criteria[i].getAttributeName().equals(criteria[i + 1].getAttributeName())) {
                        if (!(criteria[i].getOperator() != ">=" && criteria[i].getOperator() != ">" || criteria[i + 1].getOperator() != "<" && criteria[i + 1].getOperator() != "<=")) {
                            ListTrapdoorForRange = Query.generateTrapdoorforRange(criteria[i], criteria[i + 1], y_Key, z_Key);
                            ++i;
                        } else if (!(criteria[i].getOperator() != "<=" && criteria[i].getOperator() != "<" || criteria[i + 1].getOperator() != ">" && criteria[i + 1].getOperator() != ">=")) {
                            ListTrapdoorForRange = Query.generateTrapdoorforRange(criteria[i + 1], criteria[i], y_Key, z_Key);
                            ++i;
                        }
                    } else if (criteria[i].getOperator() == "<=" || criteria[i].getOperator() == "<") {
                        fake = new Criteria(null, null, null);
                        ListTrapdoorForRange = Query.generateTrapdoorforRange(fake, criteria[i], y_Key, z_Key);
                    } else if (criteria[i].getOperator() == ">=" || criteria[i].getOperator() == ">") {
                        fake = new Criteria(null, null, null);
                        ListTrapdoorForRange = Query.generateTrapdoorforRange(criteria[i], fake, y_Key, z_Key);
                    }
                    TreeSet<Object> keywords = new TreeSet<Object>(ListTrapdoorForRange.keySet());
                    Iterator it = keywords.iterator();
                    while (it.hasNext()) {
                        keyword = (String)it.next();
                        System.out.println("Trapdoor for keyword" + keyword);
                        trap = (String[])ListTrapdoorForRange.get(keyword);
                        System.out.println("[" + trap[0] + ", " + trap[1] + "\n");
                        String query = "(select * from search_with_SE((select index from " + Constants.tableName + Constants.indexName + "),ARRAY['" + trap[0] + "', '" + trap[1] + "']))";
                        Criteria trapdoor = new Criteria("rowID", "IN", query);
                        myCriteria.add(trapdoor);
                        if (!it.hasNext()) continue;
                        myCriteria.add(new Criteria("", "OR", ""));
                    }
                    myCriteria.add(new Criteria("", ")", ""));
                    continue;
                }
                keyword = criteria[i].getAttributeName() + criteria[i].getOperator() + criteria[i].getValue();
                try {
                    trap = Query.generateTrapdoor(keyword, y_Key, z_Key);
                }
                catch (IOException e) {
                    System.out.println("[FAILURE:] Trapdoor generation for keyword " + keyword);
                }
                System.out.println("Trapdoor for keyword " + keyword);
                System.out.println("[" + trap[0] + ", " + trap[1] + "]\n");
                String query = "(select * from search_with_SE((select index from " + Constants.tableName + Constants.indexName + "),ARRAY['" + trap[0] + "', '" + trap[1] + "']))";
                Criteria trapdoor = new Criteria("rowID", "IN", query);
                myCriteria.add(trapdoor);
                continue;
            }
            myCriteria.add(new Criteria("", criteria[i].getOperator(), ""));
        }
        String[] encrypted_attributes = new String[attributeNames.length + 1];
        for (int i = 0; i < attributeNames.length; ++i) {
            SecretKey newSK = KeyManagementUtils.hashAESKey(encryption_Key, Integer.toString(indexes[i] + 1));
            encrypted_attributes[i] = Encryptor.encrypt(attributeNames[i], newSK, true);
        }
        encrypted_attributes[attributeNames.length] = "rowID";
        SE_search_query.setProtectedAttributeNames(encrypted_attributes);
        SE_search_query.setCriteria(myCriteria.toArray(new Criteria[myCriteria.size()]));
        myList.add(SE_search_query);
        return myList;
    }

    private static String[] generateTrapdoor(String keyword, SecretKey prfKey, SecretKey permKey) throws Exception {
        String[] trapdoor = new String[]{Base64.getEncoder().encodeToString(Encryptor.prf(keyword, prfKey)), Encryptor.encrypt(keyword, permKey)};
        return trapdoor;
    }

    private static Map<String, String[]> generateTrapdoorforRange(Criteria rangeInf, Criteria rangeSup, SecretKey prfKey, SecretKey permKey) throws Exception {
        int ii;
        HashMap<String, String[]> ListTrapdoorForRange = new HashMap<String, String[]>();
        String a = rangeInf.getAttributeName() != null ? rangeInf.getAttributeName() : rangeSup.getAttributeName();
        Map<String, String>[] config = Query.loadConfig(Constants.tableName + ".config");
        Map<String, String> minmax = config[0];
        Map<String, String> range_config = config[1];
        String min = minmax.get(a).split(":")[0];
        String max = minmax.get(a).split(":")[1];
        if (rangeInf.getAttributeName() == null && rangeInf.getOperator() == null && rangeInf.getValue() == null) {
            rangeInf.setAttributeName(a);
            rangeInf.setOperator(">=");
            rangeInf.setValue(min);
        }
        if (rangeSup.getAttributeName() == null && rangeSup.getOperator() == null && rangeSup.getValue() == null) {
            rangeSup.setAttributeName(a);
            rangeSup.setOperator("<=");
            rangeSup.setValue(max);
        }
        int ll = Integer.valueOf(minmax.get(a).split(":")[2]);
        int initial = Integer.valueOf(range_config.get(a).split(":")[0]);
        int range = Integer.valueOf(range_config.get(a).split(":")[1]);
        double x = ((double)Integer.valueOf(rangeInf.getValue()).intValue() - (double)initial) / (double)range;
        double y = ((double)(Integer.valueOf(rangeSup.getValue()) + 1) - (double)initial) / (double)range;
        int inf_discrete = x % 1.0 == 0.0 && rangeInf.getOperator() == ">=" ? Integer.valueOf(rangeInf.getValue()) : (x % 1.0 == 0.0 && rangeInf.getOperator() == ">" ? (int)(x + 1.0) * range + initial : (int)Math.ceil(x) * range + initial);
        int sup_discrete = y % 1.0 == 0.0 && rangeSup.getOperator() == "<=" ? Integer.valueOf(rangeSup.getValue()) : (y % 1.0 == 0.0 && rangeSup.getOperator() == "<" ? (int)(y - 1.0) * range + initial : (int)Math.floor(y) * range + initial);
        if (inf_discrete > Integer.valueOf(rangeInf.getValue())) {
            for (int ii2 = 0; ii2 < inf_discrete - Integer.valueOf(rangeInf.getValue()); ++ii2) {
                if (ii2 == 0 && rangeInf.getOperator() != ">=") continue;
                int val = Integer.valueOf(rangeInf.getValue()) + ii2;
                String keyword = a + "='" + String.format("%0" + ll + "d", val) + "'";
                ListTrapdoorForRange.put(keyword, Query.generateTrapdoor(keyword, prfKey, permKey));
            }
        }
        int nb_ranges = (sup_discrete + 1 - inf_discrete) / range;
        for (ii = 0; ii < nb_ranges; ++ii) {
            int val1 = inf_discrete + ii * range;
            int val2 = inf_discrete + (ii + 1) * range - 1;
            String keyword = "RANGE_" + a + "='" + String.format("%0" + ll + "d", val1) + "-" + String.format("%0" + ll + "d", val2) + "'";
            ListTrapdoorForRange.put(keyword, Query.generateTrapdoor(keyword, prfKey, permKey));
        }
        if (Integer.valueOf(rangeSup.getValue()) > sup_discrete) {
            for (ii = 0; ii < Integer.valueOf(rangeSup.getValue()) - sup_discrete; ++ii) {
                int val = sup_discrete + ii;
                String keyword = a + "='" + String.format("%0" + ll + "d", val) + "'";
                ListTrapdoorForRange.put(keyword, Query.generateTrapdoor(keyword, prfKey, permKey));
            }
        }
        if (rangeSup.getOperator() == "<=" && Integer.valueOf(rangeSup.getValue()) != sup_discrete) {
            String keyword = a + "='" + String.format("%0" + ll + "d", Integer.valueOf(rangeSup.getValue())) + "'";
            ListTrapdoorForRange.put(keyword, Query.generateTrapdoor(keyword, prfKey, permKey));
        }
        return ListTrapdoorForRange;
    }

    public static Map<String, String>[] loadConfig(String filename) throws FileNotFoundException, IOException, ClassNotFoundException {
        Map[] config = new Map[2];
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        config = (Map[])in.readObject();
        in.close();
        return config;
    }
}

