/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.SEmodule.Constants;
import eu.clarussecure.dataoperations.SEmodule.Encryptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Scanner;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class KeyManagementUtils {
    private static Logger logger = Logger.getLogger(KeyManagementUtils.class);

    public static SecretKey[] procedureKeyGen() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        SecretKey[] output = new SecretKey[3];
        String keyType = "AES";
        String keyLength = "128";
        SecretKey encryption_Key = KeyManagementUtils.generateKey(keyType, keyLength);
        logger.info((Object)("\nGenerated Encryption Key: [" + KeyManagementUtils.convertAESKeyToString(encryption_Key) + "]"));
        output[0] = encryption_Key;
        SecretKey prfKey = KeyManagementUtils.generateKey(keyType, keyLength);
        SecretKey permKey = KeyManagementUtils.generateKey(keyType, keyLength);
        output[1] = prfKey;
        output[2] = permKey;
        logger.info((Object)("Generated Pseudo Random Function (PRF) key: [" + KeyManagementUtils.convertAESKeyToString(prfKey) + "]"));
        logger.info((Object)("Generated cuckoo hash table  initial (Pi) key: [" + KeyManagementUtils.convertAESKeyToString(permKey) + "]\n"));
        String ksName = "clarus_keystore";
        char[] ksPassword = KeyManagementUtils.askPassword(ksName);
        KeyManagementUtils.createKeyStore(ksName, ksPassword);
        KeyStore myKS = KeyManagementUtils.loadKeyStore(ksName, ksPassword);
        KeyManagementUtils.storeSecretKey(myKS, encryption_Key, "encKey", ksPassword);
        KeyManagementUtils.storeSecretKey(myKS, prfKey, "y_Key", ksPassword);
        KeyManagementUtils.storeSecretKey(myKS, permKey, "z_Key", ksPassword);
        KeyManagementUtils.storeKeyStore(ksName, myKS, ksPassword);
        logger.info((Object)"\n");
        return output;
    }

    public static SecretKey[] loadSecretKeys() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        String ksName = "clarus_keystore";
        char[] ksPassword = KeyManagementUtils.askPassword(ksName);
        KeyStore myKS = KeyManagementUtils.loadKeyStore(ksName, ksPassword);
        SecretKey encryption_Key = KeyManagementUtils.loadSecretKey(myKS, "encKey", ksPassword);
        SecretKey prfKey = KeyManagementUtils.loadSecretKey(myKS, "y_Key", ksPassword);
        SecretKey permKey = KeyManagementUtils.loadSecretKey(myKS, "z_Key", ksPassword);
        SecretKey[] output = new SecretKey[]{encryption_Key, prfKey, permKey};
        return output;
    }

    private static SecretKey generateKey(String type, String size) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(type);
        keyGenerator.init(Integer.parseInt(size));
        return keyGenerator.generateKey();
    }

    public static SecretKey hashAESKey(SecretKey masterKey, String salt) throws Exception {
        char[] hex = Hex.encodeHex((byte[])masterKey.getEncoded());
        String aesKeyString = String.valueOf(hex);
        aesKeyString = aesKeyString.substring(0, 16);
        aesKeyString = Encryptor.Xor(aesKeyString, salt);
        SecretKeySpec key = new SecretKeySpec(aesKeyString.getBytes(), "AES");
        return key;
    }

    private static void createKeyStore(String ksName, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("JCEKS");
        ks.load(null, password);
        FileOutputStream fos = new FileOutputStream(ksName);
        ks.store(fos, password);
        logger.info((Object)"New keystore created");
        fos.close();
    }

    private static void storeKeyStore(String ksName, KeyStore ks, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream fos = new FileOutputStream(ksName);
        ks.store(fos, password);
        logger.info((Object)"Keystore saved!");
        fos.close();
    }

    public static KeyStore loadKeyStore(String ksName, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("JCEKS");
        FileInputStream is = new FileInputStream(ksName);
        try {
            ks.load(is, password);
        }
        catch (IOException e) {
            logger.info((Object)"Wrong Password...");
            System.exit(1);
        }
        logger.info((Object)"Keystore loaded!");
        return ks;
    }

    private static void storeSecretKey(KeyStore ks, SecretKey key, String alias, char[] password) throws KeyStoreException {
        KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(key);
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(password);
        ks.setEntry(alias, skEntry, protParam);
        String keyName = KeyManagementUtils.getKeyName(alias);
        logger.info((Object)(keyName + " inserted in the keystore"));
    }

    public static SecretKey loadSecretKey(KeyStore ks, String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(password);
        KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ks.getEntry(alias, protParam);
        SecretKey key = skEntry.getSecretKey();
        String keyName = KeyManagementUtils.getKeyName(alias);
        logger.info((Object)(keyName + " loaded from the keystore"));
        return key;
    }

    public static char[] askPassword(String myObject) {
        if (Constants.passwd == null) {
            Scanner pwd_input = new Scanner(System.in);
            logger.info((Object)("Please enter a password for " + myObject + ": "));
            String read_pwd = pwd_input.nextLine();
            char[] password = read_pwd.toCharArray();
            Constants.passwd = password;
        }
        return Constants.passwd;
    }

    private static String getKeyName(String alias) {
        return alias == "encKey" ? "Encryption Key" : (alias == "y_Key" ? "PRF key" : "Pi key");
    }

    public static String convertAESKeyToString(Key key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static String convertAESKeyToHexa(Key key) {
        return String.valueOf(Hex.encodeHex((byte[])key.getEncoded()));
    }
}

