/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.SEmodule.Constants;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryptor {
    public static String encrypt(String key, String value) {
        return Encryptor.encrypt(key, value, false);
    }

    public static String encrypt(String key, String value, boolean safe) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            IvParameterSpec iv = new IvParameterSpec(skeySpec.getEncoded());
            Cipher cipher = Cipher.getInstance(Constants.transformation);
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            Base64.Encoder encoder = safe ? Base64.getUrlEncoder() : Base64.getEncoder();
            return encoder.encodeToString(encrypted);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String Data, Key key) throws Exception {
        return Encryptor.encrypt(Data, key, false);
    }

    public static String encrypt(String Data, Key key, boolean safe) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(key.getEncoded());
        SecretKeySpec skeySpec = new SecretKeySpec(key.getEncoded(), "AES");
        Cipher c = Cipher.getInstance(Constants.transformation);
        c.init(1, (Key)skeySpec, iv);
        byte[] encVal = c.doFinal(Data.getBytes(Constants.charset));
        Base64.Encoder encoder = safe ? Base64.getUrlEncoder() : Base64.getEncoder();
        String encryptedValue = encoder.encodeToString(encVal);
        return encryptedValue;
    }

    public static String decrypt(String key, String encrypted) {
        return Encryptor.decrypt(key, encrypted, false);
    }

    public static String decrypt(String key, String encrypted, boolean safe) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            IvParameterSpec iv = new IvParameterSpec(skeySpec.getEncoded());
            Cipher cipher = Cipher.getInstance(Constants.transformation);
            cipher.init(2, (Key)skeySpec, iv);
            Base64.Decoder decoder = safe ? Base64.getUrlDecoder() : Base64.getDecoder();
            byte[] original = cipher.doFinal(decoder.decode(encrypted));
            return new String(original);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String encryptedData, Key key) throws Exception {
        return Encryptor.decrypt(encryptedData, key, false);
    }

    public static String decrypt(String encryptedData, Key key, boolean safe) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(key.getEncoded());
        SecretKeySpec skeySpec = new SecretKeySpec(key.getEncoded(), "AES");
        Cipher c = Cipher.getInstance(Constants.transformation);
        c.init(2, (Key)skeySpec, iv);
        Base64.Decoder decoder = safe ? Base64.getUrlDecoder() : Base64.getDecoder();
        byte[] decordedValue = decoder.decode(encryptedData);
        byte[] decValue = c.doFinal(decordedValue);
        String decryptedValue = new String(decValue);
        return decryptedValue;
    }

    public static byte[] prf(String a, SecretKey key) {
        try {
            Mac mac = Mac.getInstance(Constants.prf);
            mac.init(key);
            byte[] b = a.getBytes(Constants.charset);
            return mac.doFinal(b);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String Xor(String a, String XorKey) {
        char[] key = XorKey.toCharArray();
        StringBuilder output = new StringBuilder();
        int aL = a.length();
        int kL = key.length;
        for (int i = 0; i < aL; ++i) {
            output.append((char)(a.charAt(i) ^ key[i % kL]));
        }
        return output.toString();
    }
}

