/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.SEmodule.HashFunction;
import eu.clarussecure.dataoperations.SEmodule.UniversalHashFunction;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;

public final class CuckooHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -5994084415487321880L;
    private static final int kStartSize = 4;
    private static final float kMaxLoadFactor = 0.4f;
    private Map.Entry<K, V>[][] mArrays = new Map.Entry[2][4];
    private final HashFunction<? super K>[] mHashFns = new HashFunction[2];
    private final UniversalHashFunction<? super K> mUniversalHashFunction;
    private int mSize = 0;

    public CuckooHashMap() {
        this(new DefaultUniversalHashFunction());
    }

    private CuckooHashMap(UniversalHashFunction<? super K> fn) {
        if (fn == null) {
            throw new NullPointerException("Universal hash function must be non-null.");
        }
        this.mUniversalHashFunction = fn;
        this.generateHashFunctions();
    }

    @Override
    public V put(K key, V value) {
        for (int i = 0; i < 2; ++i) {
            int hash = this.mHashFns[i].hash(key);
            Map.Entry<K, V> entry = this.mArrays[i][hash];
            if (entry == null || !CuckooHashMap.isEqual(entry.getKey(), key)) continue;
            V result = entry.getValue();
            entry.setValue(value);
            return result;
        }
        if ((float)this.size() >= 0.4f * (float)this.mArrays[0].length * 2.0f) {
            this.grow();
        }
        Map.Entry<K, V> toInsert = new AbstractMap.SimpleEntry<K, V>(key, value);
        while ((toInsert = this.tryInsertEntry(toInsert)) != null) {
            this.rehash();
        }
        ++this.mSize;
        return null;
    }

    private Map.Entry<K, V> tryInsertEntry(Map.Entry<K, V> toInsert) {
        for (int numTries = 0; numTries < this.size() + 1; ++numTries) {
            int hash = this.mHashFns[numTries % 2].hash(toInsert.getKey());
            Map.Entry<K, V> entry = this.mArrays[numTries % 2][hash];
            if (entry == null) {
                this.mArrays[numTries % 2][hash] = toInsert;
                return null;
            }
            this.mArrays[numTries % 2][hash] = toInsert;
            toInsert = entry;
        }
        return toInsert;
    }

    private static <T> boolean isEqual(T one, T two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    private void generateHashFunctions() {
        for (int i = 0; i < 2; ++i) {
            this.mHashFns[i] = this.mUniversalHashFunction.randomHashFunction(this.mArrays[0].length);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void rehash() {
        values = this.entrySet().toArray(new Map.Entry[0]);
        while (true) {
            for (i = 0; i < 2; ++i) {
                Arrays.fill(this.mArrays[i], null);
            }
            this.generateHashFunctions();
            for (Map.Entry entry : values) {
                if (this.tryInsertEntry(entry) != null) ** continue;
            }
            break;
        }
    }

    private void grow() {
        Map.Entry<K, V>[][] oldArrays = this.mArrays;
        this.mArrays = new Map.Entry[2][this.mArrays[0].length * 2];
        int writePoint = 0;
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<K, V> entry : oldArrays[i]) {
                if (entry == null) continue;
                this.mArrays[0][writePoint++] = entry;
            }
        }
        this.rehash();
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this.mArrays = new Map.Entry[2][4];
        this.mSize = 0;
        this.generateHashFunctions();
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < 2; ++i) {
            int hash = this.mHashFns[i].hash(key);
            if (this.mArrays[i][hash] == null || !CuckooHashMap.isEqual(this.mArrays[i][hash].getKey(), key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < 2; ++i) {
            int hash = this.mHashFns[i].hash(key);
            if (this.mArrays[i][hash] == null || !CuckooHashMap.isEqual(this.mArrays[i][hash].getKey(), key)) continue;
            return this.mArrays[i][hash].getValue();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        for (int i = 0; i < 2; ++i) {
            int hash = this.mHashFns[i].hash(key);
            if (this.mArrays[i][hash] == null || !CuckooHashMap.isEqual(this.mArrays[i][hash].getKey(), key)) continue;
            V result = this.mArrays[i][hash].getValue();
            this.mArrays[i][hash] = null;
            --this.mSize;
            return result;
        }
        return null;
    }

    public EntrySet entrySet() {
        return new EntrySet();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return CuckooHashMap.this.size();
        }

        @Override
        public boolean contains(Object entry) {
            if (entry == null) {
                return false;
            }
            Map.Entry realEntry = (Map.Entry)entry;
            if (!CuckooHashMap.this.containsKey(realEntry.getKey())) {
                return false;
            }
            Object value = CuckooHashMap.this.get(realEntry.getKey());
            return CuckooHashMap.isEqual(value, realEntry.getValue());
        }

        @Override
        public boolean remove(Object entry) {
            if (!this.contains(entry)) {
                return false;
            }
            Map.Entry realEntry = (Map.Entry)entry;
            CuckooHashMap.this.remove(realEntry.getKey());
            return true;
        }

        @Override
        public void clear() {
            CuckooHashMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator();
        }

        public final class MapIterator
        implements Iterator<Map.Entry<K, V>> {
            private int mNextTable = 0;
            private int mNextIndex = 0;
            private Map.Entry<K, V> mLast = null;

            public MapIterator() {
                this.stageNext();
            }

            @Override
            public boolean hasNext() {
                return this.mNextTable != 2;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Out of elements.");
                }
                Map.Entry result = CuckooHashMap.this.mArrays[this.mNextTable][this.mNextIndex];
                ++this.mNextIndex;
                this.stageNext();
                this.mLast = result;
                return result;
            }

            @Override
            public void remove() {
                if (this.mLast == null) {
                    throw new IllegalStateException("No element staged.");
                }
                EntrySet.this.remove(this.mLast);
                this.mLast = null;
            }

            private void stageNext() {
                while (this.mNextTable < 2) {
                    while (this.mNextIndex < CuckooHashMap.this.mArrays[0].length) {
                        if (CuckooHashMap.this.mArrays[this.mNextTable][this.mNextIndex] != null) {
                            return;
                        }
                        ++this.mNextIndex;
                    }
                    this.mNextIndex = 0;
                    ++this.mNextTable;
                }
            }
        }
    }

    private static final class DefaultUniversalHashFunction<T>
    implements UniversalHashFunction<T>,
    Serializable {
        private static final long serialVersionUID = -2174397823899972178L;
        private final Random mRandom = new Random();

        private DefaultUniversalHashFunction() {
        }

        @Override
        public HashFunction<T> randomHashFunction(int numBuckets) {
            int lgBuckets = -1;
            while (numBuckets > 0) {
                ++lgBuckets;
                numBuckets >>>= 1;
            }
            return new DefaultHashFunction(this.mRandom.nextInt(), this.mRandom.nextInt(), lgBuckets);
        }
    }

    private static final class DefaultHashFunction<T>
    implements HashFunction<T>,
    Serializable {
        private static final long serialVersionUID = 8525462945737565660L;
        private final int mA;
        private final int mB;
        private final int mLgSize;

        public DefaultHashFunction(int a, int b, int lgSize) {
            this.mA = a;
            this.mB = b;
            this.mLgSize = lgSize;
        }

        @Override
        public int hash(T obj) {
            if (obj == null) {
                return 0;
            }
            int objHash = obj.hashCode();
            int upper = objHash >>> 16;
            int lower = objHash & 0xFFFF;
            return upper * this.mA + lower * this.mB >>> 32 - this.mLgSize;
        }
    }
}

