/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.SEmodule;

import eu.clarussecure.dataoperations.SEmodule.CuckooHashMap;
import eu.clarussecure.dataoperations.SEmodule.Encryptor;
import eu.clarussecure.dataoperations.SEmodule.Permutation;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.log4j.Logger;

public class BuildIndex {
    private static Logger logger = Logger.getLogger(BuildIndex.class);
    private static Map<String, LinkedList<String>> dictionary = new HashMap<String, LinkedList<String>>();
    private static int numberOfElements = 0;

    public static ArrayList<Object> buildIndex(String[] attributes, String[][] contents, SecretKey prfKey, SecretKey permKey) throws Exception {
        Map<String, LinkedList<String>> dictionary = BuildIndex.CreateDictionary(attributes, contents);
        int numberOfElements = BuildIndex.getNumberOfElements();
        int sizeOfArrayA = (int)Math.pow(2.0, Math.ceil(Math.log(numberOfElements) / Math.log(2.0)));
        ArrayList<Object> index = BuildIndex.BuildAandT(dictionary, sizeOfArrayA, prfKey, permKey);
        return index;
    }

    public static Map<String, LinkedList<String>> CreateDictionary(String[] attributes, String[][] contents) {
        logger.info((Object)"Create dictionary");
        dictionary.clear();
        int col = attributes.length;
        int row = contents.length;
        for (int r = 0; r < row; ++r) {
            String rowID = "row" + String.valueOf(r + 1);
            String[] record = contents[r];
            for (int c = 0; c < col; ++c) {
                LinkedList<Object> ll;
                String keyword = attributes[c] + "=" + record[c];
                if (!dictionary.containsKey(keyword)) {
                    ll = new LinkedList<String>();
                    ll.add(rowID);
                    ++numberOfElements;
                    dictionary.put(keyword, ll);
                    continue;
                }
                ll = dictionary.get(keyword);
                ll.add(rowID);
                ++numberOfElements;
                dictionary.put(keyword, ll);
            }
        }
        return dictionary;
    }

    public static ArrayList<Object> BuildAandT(Map<String, LinkedList<String>> dictionary, int sizeOfA, SecretKey prfKey, SecretKey permKey) throws Exception {
        logger.info((Object)"Create index from dictionary");
        int counter = 0;
        String[] arrayA = new String[sizeOfA];
        CuckooHashMap<String, String> T = new CuckooHashMap<String, String>();
        int[] permuted = new int[sizeOfA];
        permuted = Permutation.permute_array(sizeOfA);
        Set<Map.Entry<String, LinkedList<String>>> dict = dictionary.entrySet();
        for (Map.Entry<String, LinkedList<String>> e : dict) {
            String k_i0 = RandomStringUtils.randomAlphabetic((int)16);
            String firstNodeInformation = permuted[counter] + "||" + k_i0;
            String XorKey = Base64.getEncoder().encodeToString(Encryptor.prf(e.getKey(), prfKey));
            String encryptedFirstNodeInfo = Encryptor.Xor(firstNodeInformation, XorKey);
            T.put(Encryptor.encrypt(e.getKey(), permKey), encryptedFirstNodeInfo);
            Iterator it_ll = e.getValue().iterator();
            String current_key = k_i0;
            for (int i = 0; i < e.getValue().size(); ++i) {
                String encrypted_node;
                String node;
                if (i == e.getValue().size() - 1) {
                    node = (String)it_ll.next() + "||-||-1";
                    arrayA[permuted[counter]] = encrypted_node = Encryptor.encrypt(current_key, node);
                    ++counter;
                    continue;
                }
                String k_ij = RandomStringUtils.randomAlphabetic((int)16);
                node = (String)it_ll.next() + "||" + k_ij + "||" + permuted[counter + 1];
                arrayA[permuted[counter]] = encrypted_node = Encryptor.encrypt(current_key, node);
                current_key = k_ij;
                ++counter;
            }
        }
        for (int i = counter + 1; i < sizeOfA; ++i) {
            String key = RandomStringUtils.randomAlphabetic((int)16);
            arrayA[permuted[i]] = Encryptor.encrypt(key, key);
        }
        ArrayList<Object> output = new ArrayList<Object>();
        output.add(arrayA);
        output.add(T);
        return output;
    }

    public static int getNumberOfElements() {
        return numberOfElements;
    }
}

