/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.api.WordSplit;
import eu.clarin.weblicht.wlfxb.tc.api.WordSplittingLayer;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.tc.xb.WordSplitStored;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="WordSplittings")
@XmlAccessorType(value=XmlAccessType.NONE)
public class WordSplittingLayerStored
extends TextCorpusLayerStoredAbstract
implements WordSplittingLayer {
    public static final String XML_NAME = "WordSplittings";
    @XmlAttribute(name="type")
    private String type;
    @XmlElement(name="split")
    private List<WordSplitStored> splits = new ArrayList<WordSplitStored>();
    private TextCorpusLayersConnector connector;

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (WordSplitStored split : this.splits) {
            connector.token2ItsSplit.put(connector.tokenId2ItsToken.get(split.tokRef), split);
        }
    }

    protected WordSplittingLayerStored() {
    }

    protected WordSplittingLayerStored(String type) {
        this.type = type;
    }

    protected WordSplittingLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.splits.isEmpty();
    }

    @Override
    public int size() {
        return this.splits.size();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public WordSplit getSplit(int index) {
        return this.splits.get(index);
    }

    @Override
    public WordSplit getSplit(Token token) {
        return this.connector.token2ItsSplit.get(token);
    }

    @Override
    public Token getToken(WordSplit split) {
        if (split instanceof WordSplitStored) {
            return this.connector.tokenId2ItsToken.get(((WordSplitStored)split).tokRef);
        }
        throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(WordSplit.class, WordSplittingLayer.class));
    }

    @Override
    public WordSplit addSplit(Token token, int[] splitIndices) {
        WordSplitStored wordSplit = new WordSplitStored();
        wordSplit.splitIndices = splitIndices;
        wordSplit.tokRef = token.getID();
        this.splits.add(wordSplit);
        return wordSplit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        sb.append(this.type);
        sb.append("}: ");
        sb.append(this.splits.toString());
        return sb.toString();
    }
}

