/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.api.TopologicalField;
import eu.clarin.weblicht.wlfxb.tc.api.TopologicalFieldsLayer;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.tc.xb.TopologicalFieldStored;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="topologicalFields")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TopologicalFieldsLayerStored
extends TextCorpusLayerStoredAbstract
implements TopologicalFieldsLayer {
    public static final String XML_NAME = "topologicalFields";
    @XmlAttribute(name="tagset", required=true)
    private String tagset;
    @XmlElement(name="field")
    private List<TopologicalFieldStored> tags = new ArrayList<TopologicalFieldStored>();
    private TextCorpusLayersConnector connector;

    protected TopologicalFieldsLayerStored() {
    }

    protected TopologicalFieldsLayerStored(String tagset) {
        this.tagset = tagset;
    }

    protected TopologicalFieldsLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (TopologicalFieldStored tag : this.tags) {
            for (String tokRef : tag.tokRefs) {
                connector.token2ItsTopoField.put(connector.tokenId2ItsToken.get(tokRef), tag);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public String getTagset() {
        return this.tagset;
    }

    @Override
    public TopologicalField getTag(int index) {
        TopologicalField tag = this.tags.get(index);
        return tag;
    }

    @Override
    public TopologicalField getTag(Token token) {
        TopologicalField tag = this.connector.token2ItsTopoField.get(token);
        return tag;
    }

    @Override
    public Token[] getTokens(TopologicalField tag) {
        if (tag instanceof TopologicalFieldStored) {
            TopologicalFieldStored tagStored = (TopologicalFieldStored)tag;
            return WlfUtilities.tokenIdsToTokens(tagStored.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public TopologicalField addTag(String tagString, Token tagToken) {
        List<Token> tagTokens = Arrays.asList(tagToken);
        return this.addTag(tagString, tagTokens);
    }

    @Override
    public TopologicalField addTag(String tagString, List<Token> tagTokens) {
        TopologicalFieldStored tag = new TopologicalFieldStored();
        tag.tagString = tagString;
        tag.tokRefs = new String[tagTokens.size()];
        for (int i = 0; i < tagTokens.size(); ++i) {
            Token token = tagTokens.get(i);
            tag.tokRefs[i] = token.getID();
            this.connector.token2ItsTopoField.put(token, tag);
        }
        this.tags.add(tag);
        return tag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" ");
        sb.append("{");
        sb.append(this.tagset);
        sb.append("} :");
        sb.append(this.tags.toString());
        return sb.toString();
    }
}

