/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Cooccurrence;
import eu.clarin.weblicht.wlfxb.lx.api.CooccurrenceFunction;
import eu.clarin.weblicht.wlfxb.lx.api.CooccurrencesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.Entry;
import eu.clarin.weblicht.wlfxb.lx.api.Sig;
import eu.clarin.weblicht.wlfxb.lx.api.Term;
import eu.clarin.weblicht.wlfxb.lx.xb.CooccurrenceStored;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.SigStored;
import eu.clarin.weblicht.wlfxb.lx.xb.TermStored;
import eu.clarin.weblicht.wlfxb.lx.xb.TermsContainerStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="cooccurrences")
@XmlAccessorType(value=XmlAccessType.NONE)
public class CooccurrencesLayerStored
extends TermsContainerStored
implements CooccurrencesLayer {
    public static final String XML_NAME = "cooccurrences";
    @XmlElement(name="cooccurrence")
    private List<CooccurrenceStored> coocs = new ArrayList<CooccurrenceStored>();

    protected CooccurrencesLayerStored() {
    }

    protected CooccurrencesLayerStored(LexiconLayersConnector connector) {
        super(connector);
    }

    @Override
    protected void setLayersConnector(LexiconLayersConnector connector) {
        super.setLayersConnector(connector);
        for (CooccurrenceStored cooc : this.coocs) {
            this.connect(cooc);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.coocs.isEmpty();
    }

    @Override
    public int size() {
        return this.coocs.size();
    }

    @Override
    public Cooccurrence getCooccurrence(int index) {
        return this.coocs.get(index);
    }

    @Override
    public Cooccurrence[] getCooccurrences(Entry entry) {
        List<Cooccurrence> coocList = this.connector.entry2ItsCoocs.get(entry);
        if (coocList != null) {
            return coocList.toArray(new Cooccurrence[coocList.size()]);
        }
        return new Cooccurrence[0];
    }

    @Override
    public Entry[] getEntries(Cooccurrence cooccurrence) {
        if (cooccurrence instanceof CooccurrenceStored) {
            CooccurrenceStored cooc = (CooccurrenceStored)cooccurrence;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (TermStored t : cooc.terms) {
                if (t.entryId == null) continue;
                entries.add(this.connector.entryId2ItsEntry.get(t.entryId));
            }
            return entries.toArray(new Entry[entries.size()]);
        }
        return null;
    }

    @Override
    public String[] getTermsAsStrings(Cooccurrence cooccurrence, boolean includeAnnotatedTerm) {
        if (cooccurrence instanceof CooccurrenceStored) {
            CooccurrenceStored cooc = (CooccurrenceStored)cooccurrence;
            return super.getTermsAsStrings(cooc.terms, includeAnnotatedTerm);
        }
        return null;
    }

    @Override
    public Cooccurrence addCooccurrence(CooccurrenceFunction function, List<Term> terms) {
        CooccurrenceStored cooc = new CooccurrenceStored();
        cooc.function = function;
        for (Term term : terms) {
            if (!(term instanceof TermStored)) continue;
            cooc.terms.add((TermStored)term);
        }
        this.connect(cooc);
        this.coocs.add(cooc);
        return cooc;
    }

    private void connect(CooccurrenceStored cooccurrence) {
        for (TermStored term : cooccurrence.terms) {
            if (term.entryId == null) continue;
            Entry entry = this.connector.entryId2ItsEntry.get(term.entryId);
            if (!this.connector.entry2ItsCoocs.containsKey(entry)) {
                this.connector.entry2ItsCoocs.put(entry, new ArrayList());
            }
            this.connector.entry2ItsCoocs.get(entry).add(cooccurrence);
        }
    }

    @Override
    public Cooccurrence addCooccurrence(CooccurrenceFunction function, Sig sig, List<Term> terms) {
        CooccurrenceStored cooc = (CooccurrenceStored)this.addCooccurrence(function, terms);
        if (sig instanceof SigStored) {
            cooc.sig = (SigStored)sig;
        }
        return cooc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.coocs.toString());
        return sb.toString();
    }
}

