/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.MorphologySegment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

@XmlRootElement(name="segment")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MorphologySegmentStored
implements MorphologySegment {
    public static final String XML_NAME = "segment";
    @XmlAttribute(name="type")
    protected String type;
    @XmlAttribute(name="func")
    protected String function;
    @XmlAttribute(name="cat")
    protected String category;
    @XmlAttribute(name="start")
    protected Integer start;
    @XmlAttribute(name="end")
    protected Integer end;
    private List<Object> content = new ArrayList<Object>();
    protected String value;
    protected List<MorphologySegmentStored> subsegments;
    @XmlAnyAttribute
    protected LinkedHashMap<QName, String> extraAttributes = new LinkedHashMap();

    @XmlMixed
    @XmlElementRefs(value={@XmlElementRef(name="segment", type=MorphologySegmentStored.class)})
    protected List<Object> getContent() {
        ArrayList<Object> contentToMarshal = new ArrayList<Object>();
        if (this.subsegments != null) {
            contentToMarshal.addAll(this.subsegments);
        } else if (this.value != null) {
            contentToMarshal.add(this.value);
        } else {
            return null;
        }
        return contentToMarshal;
    }

    void setContent(List<Object> content) {
        this.content = content;
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        for (Object obj : this.content) {
            if (obj instanceof String) {
                String v = ((String)obj).trim();
                if (this.subsegments != null || v.length() <= 0) continue;
                this.value = v;
                return;
            }
            if (!(obj instanceof MorphologySegmentStored)) continue;
            if (this.subsegments == null) {
                this.subsegments = new ArrayList<MorphologySegmentStored>();
            }
            this.subsegments.add((MorphologySegmentStored)obj);
        }
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public boolean hasCharoffsets() {
        return this.start != null && this.end != null;
    }

    @Override
    public Integer getStart() {
        return this.start;
    }

    @Override
    public Integer getEnd() {
        return this.end;
    }

    @Override
    public boolean isTerminal() {
        return this.subsegments == null || this.subsegments.isEmpty();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public MorphologySegment[] getSubsegments() {
        if (this.subsegments == null) {
            return null;
        }
        return this.subsegments.toArray(new MorphologySegment[this.subsegments.size()]);
    }

    @Override
    public LinkedHashMap<String, String> getExtraAttributes() {
        return MorphologySegment.super.retrieveAttributes(this.extraAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(this.type);
            sb.append(" ");
        }
        if (this.function != null) {
            sb.append(this.function);
            sb.append(" ");
        }
        if (this.category != null) {
            sb.append(this.category);
            sb.append(" ");
        }
        if (this.hasCharoffsets()) {
            sb.append(this.start);
            sb.append(" ");
            sb.append(this.end);
            sb.append(" ");
        }
        if (this.isTerminal()) {
            sb.append(this.value);
        } else if (this.subsegments != null && !this.subsegments.isEmpty()) {
            sb.append(this.subsegments.toString());
        }
        return sb.toString();
    }
}

