/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Dependency;
import eu.clarin.weblicht.wlfxb.tc.api.DependencyParse;
import eu.clarin.weblicht.wlfxb.tc.api.DependencyParsingLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.DependencyParseStored;
import eu.clarin.weblicht.wlfxb.tc.xb.DependencyStored;
import eu.clarin.weblicht.wlfxb.tc.xb.EmptyTokenStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="depparsing")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DependencyParsingLayerStored
extends TextCorpusLayerStoredAbstract
implements DependencyParsingLayer {
    public static final String XML_NAME = "depparsing";
    public static final String XML_ATTR_MULTIPLE_GOVERNORS = "multigovs";
    public static final String XML_ATTR_EMPTY_TOKENS = "emptytoks";
    @XmlAttribute(name="tagset")
    private String tagset;
    @XmlAttribute(name="multigovs", required=true)
    private boolean multigovs;
    @XmlAttribute(name="emptytoks", required=true)
    private boolean emptytoks;
    @XmlElement(name="parse")
    private List<DependencyParseStored> parses = new ArrayList<DependencyParseStored>();
    private TextCorpusLayersConnector connector;

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (DependencyParseStored parse : this.parses) {
            if (parse.emptytoks == null) continue;
            for (EmptyTokenStored etok : parse.emptytoks) {
                etok.order = this.connector.emptyTokId2EmptyTok.size();
                this.connector.emptyTokId2EmptyTok.put(etok.getID(), etok);
            }
        }
    }

    protected DependencyParsingLayerStored() {
    }

    protected DependencyParsingLayerStored(String tagset, Boolean hasMultipleGovernors, Boolean hasEmptyTokens) {
        this.tagset = tagset;
        this.multigovs = hasMultipleGovernors;
        this.emptytoks = hasEmptyTokens;
    }

    protected DependencyParsingLayerStored(Boolean hasMultipleGovernors, Boolean hasEmptyTokens) {
        this.multigovs = hasMultipleGovernors;
        this.emptytoks = hasEmptyTokens;
    }

    protected DependencyParsingLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.parses.isEmpty();
    }

    @Override
    public int size() {
        return this.parses.size();
    }

    @Override
    public String getTagset() {
        return this.tagset;
    }

    @Override
    public boolean hasEmptyTokens() {
        return this.emptytoks;
    }

    @Override
    public boolean hasMultipleGovernors() {
        return this.multigovs;
    }

    @Override
    public DependencyParse getParse(int index) {
        DependencyParseStored parse = this.parses.get(index);
        return parse;
    }

    @Override
    public Token[] getGovernorTokens(Dependency dependency) {
        if (dependency instanceof DependencyStored) {
            DependencyStored dep = (DependencyStored)dependency;
            if (dep.govIds != null) {
                return this.getTokens(dep.govIds);
            }
        }
        return null;
    }

    @Override
    public Token[] getDependentTokens(Dependency dependency) {
        if (dependency instanceof DependencyStored) {
            DependencyStored dep = (DependencyStored)dependency;
            return this.getTokens(dep.depIds);
        }
        return null;
    }

    private Token[] getTokens(String[] tokRefs) {
        Token[] tokens = new Token[tokRefs.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.connector.emptyTokId2EmptyTok.containsKey(tokRefs[i]) ? (Token)this.connector.emptyTokId2EmptyTok.get(tokRefs[i]) : this.connector.tokenId2ItsToken.get(tokRefs[i]);
        }
        return tokens;
    }

    @Override
    public Token createEmptyToken(String tokenString) {
        int tokenCount;
        if (tokenString == null) {
            tokenString = "";
        }
        EmptyTokenStored token = new EmptyTokenStored();
        token.tokenString = tokenString;
        token.order = tokenCount = this.connector.emptyTokId2EmptyTok.size();
        token.id = "et_" + tokenCount;
        this.connector.emptyTokId2EmptyTok.put(token.id, token);
        return token;
    }

    @Override
    public Dependency createDependency(String function, List<Token> dependent, List<Token> governor) {
        DependencyStored dep = new DependencyStored();
        dep.function = function;
        dep.depIds = WlfUtilities.tokens2TokenIds(dependent);
        dep.govIds = WlfUtilities.tokens2TokenIds(governor);
        return dep;
    }

    @Override
    public Dependency createDependency(String function, List<Token> dependent) {
        DependencyStored dep = new DependencyStored();
        dep.function = function;
        dep.depIds = WlfUtilities.tokens2TokenIds(dependent);
        return dep;
    }

    @Override
    public Dependency createDependency(List<Token> dependent, List<Token> governor) {
        return this.createDependency(null, dependent, governor);
    }

    @Override
    public Dependency createDependency(List<Token> dependent) {
        DependencyStored dep = new DependencyStored();
        dep.depIds = WlfUtilities.tokens2TokenIds(dependent);
        return dep;
    }

    @Override
    public Dependency createDependency(String function, Token dependent, Token governor) {
        DependencyStored dep = new DependencyStored();
        dep.function = function;
        dep.depIds = new String[]{dependent.getID()};
        dep.govIds = new String[]{governor.getID()};
        return dep;
    }

    @Override
    public Dependency createDependency(String function, Token dependent) {
        DependencyStored dep = new DependencyStored();
        dep.function = function;
        dep.depIds = new String[]{dependent.getID()};
        return dep;
    }

    @Override
    public Dependency createDependency(Token dependent, Token governor) {
        return this.createDependency(null, dependent, governor);
    }

    @Override
    public Dependency createDependency(Token dependent) {
        DependencyStored dep = new DependencyStored();
        dep.depIds = new String[]{dependent.getID()};
        return dep;
    }

    @Override
    public DependencyParse addParse(List<Dependency> dependencies) {
        DependencyParseStored parse = new DependencyParseStored();
        ArrayList<DependencyStored> deps = new ArrayList<DependencyStored>(dependencies.size());
        ArrayList<EmptyTokenStored> emptyTokens = new ArrayList<EmptyTokenStored>();
        for (Dependency dep : dependencies) {
            EmptyTokenStored emptyToken;
            if (!(dep instanceof DependencyStored)) continue;
            DependencyStored depS = (DependencyStored)dep;
            deps.add(depS);
            for (String ref : depS.depIds) {
                emptyToken = this.connector.emptyTokId2EmptyTok.get(ref);
                if (emptyToken == null || emptyTokens.contains(emptyToken)) continue;
                emptyTokens.add(this.connector.emptyTokId2EmptyTok.get(ref));
            }
            if (depS.govIds == null) continue;
            for (String ref : depS.govIds) {
                emptyToken = this.connector.emptyTokId2EmptyTok.get(ref);
                if (emptyToken == null || emptyTokens.contains(emptyToken)) continue;
                emptyTokens.add(this.connector.emptyTokId2EmptyTok.get(ref));
            }
        }
        if (!emptyTokens.isEmpty()) {
            parse.emptytoks = emptyTokens;
        }
        parse.dependencies = deps;
        this.parses.add(parse);
        return parse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        sb.append("tagset").append(" ").append(this.getTagset()).append(" ");
        sb.append(XML_ATTR_MULTIPLE_GOVERNORS).append(" ").append(this.multigovs).append(" ");
        sb.append(XML_ATTR_EMPTY_TOKENS).append(" ").append(this.emptytoks);
        sb.append("}: ");
        sb.append(this.parses.toString());
        return sb.toString();
    }
}

