/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Chunk;
import eu.clarin.weblicht.wlfxb.tc.api.ChunksLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.ChunkStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="chunks")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ChunksLayerStored
extends TextCorpusLayerStoredAbstract
implements ChunksLayer {
    public static final String XML_NAME = "chunks";
    @XmlAttribute(name="tagset", required=true)
    private String tagset;
    @XmlElement(name="chunk")
    private List<ChunkStored> chunks = new ArrayList<ChunkStored>();
    private Set<String> foundTypes = new HashSet<String>();
    private TextCorpusLayersConnector connector;

    protected ChunksLayerStored() {
    }

    protected ChunksLayerStored(String tagset) {
        this.tagset = tagset;
    }

    protected ChunksLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (ChunkStored ch : this.chunks) {
            for (String tokRef : ch.tokRefs) {
                Token tok = connector.tokenId2ItsToken.get(tokRef);
                if (!connector.token2ItsCH.containsKey(tok)) {
                    connector.token2ItsCH.put(tok, new ArrayList());
                }
                connector.token2ItsCH.get(tok).add(ch);
            }
            for (String type : ch.getTypes().keySet()) {
                this.foundTypes.add(type.toString());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    @Override
    public int size() {
        return this.chunks.size();
    }

    @Override
    public String getTagset() {
        return this.tagset;
    }

    @Override
    public Chunk getChunk(int index) {
        return this.chunks.get(index);
    }

    @Override
    public Chunk getChunk(Token token) {
        List<Chunk> nes = this.connector.token2ItsCH.get(token);
        if (nes != null && !nes.isEmpty()) {
            return nes.get(0);
        }
        return null;
    }

    @Override
    public List<Chunk> getChunks(Token token) {
        List<Chunk> chs = this.connector.token2ItsCH.get(token);
        return chs;
    }

    @Override
    public Token[] getTokens(Chunk chunk) {
        if (chunk instanceof ChunkStored) {
            ChunkStored ch = (ChunkStored)chunk;
            return WlfUtilities.tokenIdsToTokens(ch.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public Chunk addChunk(LinkedHashMap<String, String> chunkAttributes, Token chunkToken) {
        List<Token> tagTokens = Arrays.asList(chunkToken);
        return this.addChunk(chunkAttributes, tagTokens);
    }

    @Override
    public Chunk addChunk(LinkedHashMap<String, String> chunkAttributes, List<Token> chunkTokens) {
        ChunkStored ch = new ChunkStored();
        ch.attributes = ch.getAttributes(chunkAttributes);
        ch.tokRefs = new String[chunkTokens.size()];
        for (int i = 0; i < chunkTokens.size(); ++i) {
            Token token = chunkTokens.get(i);
            ch.tokRefs[i] = token.getID();
            Token tok = this.connector.tokenId2ItsToken.get(token.getID());
            if (!this.connector.token2ItsCH.containsKey(tok)) {
                this.connector.token2ItsCH.put(tok, new ArrayList());
            }
            this.connector.token2ItsCH.get(tok).add(ch);
        }
        this.chunks.add(ch);
        for (String type : ch.getTypes().keySet()) {
            this.foundTypes.add(type.toString());
        }
        return ch;
    }

    @Override
    public Set<String> getFoundTypes() {
        return this.foundTypes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" ");
        sb.append("{");
        sb.append(this.tagset);
        sb.append("} :");
        sb.append(this.chunks.toString());
        return sb.toString();
    }
}

