/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Entry;
import eu.clarin.weblicht.wlfxb.lx.api.Syllabification;
import eu.clarin.weblicht.wlfxb.lx.api.SyllabificationsLayer;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.SyllabificationStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="syllabifications")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SyllabificationsLayerStored
extends LexiconLayerStoredAbstract
implements SyllabificationsLayer {
    public static final String XML_NAME = "syllabifications";
    @XmlElement(name="syllabification")
    private List<SyllabificationStored> syls = new ArrayList<SyllabificationStored>();
    private LexiconLayersConnector connector;

    protected SyllabificationsLayerStored() {
    }

    protected SyllabificationsLayerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
        for (SyllabificationStored syl : this.syls) {
            connector.entry2ItsSyllab.put(connector.entryId2ItsEntry.get(syl.entryId), syl);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.syls.isEmpty();
    }

    @Override
    public int size() {
        return this.syls.size();
    }

    @Override
    public Syllabification getSyllabification(int index) {
        Syllabification syl = this.syls.get(index);
        return syl;
    }

    @Override
    public Syllabification getSyllabification(Entry entry) {
        Syllabification syl = this.connector.entry2ItsSyllab.get(entry);
        return syl;
    }

    @Override
    public Entry getEntry(Syllabification syllabification) {
        if (syllabification instanceof SyllabificationStored) {
            SyllabificationStored sylStored = (SyllabificationStored)syllabification;
            return this.connector.entryId2ItsEntry.get(sylStored.entryId);
        }
        return null;
    }

    @Override
    public Syllabification addSyllabification(String syllabificationString, Entry entry) {
        SyllabificationStored syl = new SyllabificationStored();
        syl.syllabString = syllabificationString;
        syl.entryId = entry.getID();
        this.connector.entry2ItsSyllab.put(entry, syl);
        this.syls.add(syl);
        return syl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.syls.toString());
        return sb.toString();
    }
}

