/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Entry;
import eu.clarin.weblicht.wlfxb.lx.api.PosTag;
import eu.clarin.weblicht.wlfxb.lx.api.PosTagsLayer;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.PosTagStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="POStags")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PosTagsLayerStored
extends LexiconLayerStoredAbstract
implements PosTagsLayer {
    public static final String XML_NAME = "POStags";
    @XmlAttribute(name="tagset", required=true)
    private String tagset;
    @XmlElement(name="tag")
    private List<PosTagStored> tags = new ArrayList<PosTagStored>();
    private LexiconLayersConnector connector;

    protected PosTagsLayerStored() {
    }

    protected PosTagsLayerStored(String tagset) {
        this.tagset = tagset;
    }

    protected PosTagsLayerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
        for (PosTagStored tag : this.tags) {
            this.connect(tag, connector.entryId2ItsEntry.get(tag.entryId));
        }
    }

    private void connect(PosTagStored tag, Entry entry) {
        if (!this.connector.entry2ItsTags.containsKey(entry)) {
            this.connector.entry2ItsTags.put(entry, new ArrayList());
        }
        this.connector.entry2ItsTags.get(entry).add(tag);
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public String getTagset() {
        return this.tagset;
    }

    @Override
    public PosTag getTag(int index) {
        PosTag tag = this.tags.get(index);
        return tag;
    }

    @Override
    public PosTag[] getTags(Entry entry) {
        if (this.connector.entry2ItsTags.containsKey(entry)) {
            List<PosTag> tagsList = this.connector.entry2ItsTags.get(entry);
            PosTag[] posTags = tagsList.toArray(new PosTag[tagsList.size()]);
            return posTags;
        }
        return null;
    }

    @Override
    public Entry getEntry(PosTag tag) {
        if (tag instanceof PosTagStored) {
            PosTagStored tagStored = (PosTagStored)tag;
            return this.connector.entryId2ItsEntry.get(tagStored.entryId);
        }
        return null;
    }

    @Override
    public PosTag addTag(String tagString, Entry tagEntry) {
        PosTagStored tag = new PosTagStored();
        tag.tagString = tagString;
        tag.entryId = tagEntry.getID();
        this.connect(tag, tagEntry);
        this.tags.add(tag);
        return tag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.tags.toString());
        return sb.toString();
    }
}

