/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.io;

import eu.clarin.weblicht.wlfxb.io.WLFormatException;
import eu.clarin.weblicht.wlfxb.io.XmlReaderWriter;
import eu.clarin.weblicht.wlfxb.lx.api.Lexicon;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconStored;
import eu.clarin.weblicht.wlfxb.md.xb.MetaData;
import eu.clarin.weblicht.wlfxb.tc.api.TextCorpus;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusStored;
import eu.clarin.weblicht.wlfxb.utils.CommonConstants;
import eu.clarin.weblicht.wlfxb.xb.WLData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;

public class WLDObjector {
    public static WLData read(InputStream inputStream) throws WLFormatException {
        WLData data = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WLData.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            data = (WLData)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return data;
    }

    public static WLData read(Reader reader) throws WLFormatException {
        WLData data = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WLData.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            data = (WLData)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return data;
    }

    public static WLData read(File file) throws WLFormatException {
        WLData data = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            data = WLDObjector.read(fis);
        }
        catch (IOException e) {
            throw new WLFormatException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new WLFormatException(e);
                }
            }
        }
        return data;
    }

    public static void write(WLData wlData, OutputStream outputStream) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), (Lexicon)wlData.getLexicon(), outputStream, false, wlData.getVersion());
    }

    public static void write(WLData wlData, File file) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), (Lexicon)wlData.getLexicon(), file, false, wlData.getVersion());
    }

    public static void write(WLData wlData, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), (Lexicon)wlData.getLexicon(), outputStream, outputAsXmlFragment, wlData.getVersion());
    }

    public static void write(WLData wlData, File file, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), (Lexicon)wlData.getLexicon(), file, outputAsXmlFragment, wlData.getVersion());
    }

    public static void write(MetaData md, TextCorpus tc, File file, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(md, tc, null, file, outputAsXmlFragment, "5");
    }

    public static void write(MetaData md, TextCorpus tc, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(md, tc, null, outputStream, outputAsXmlFragment, "5");
    }

    public static void write(MetaData md, Lexicon lex, File file, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(md, null, lex, file, outputAsXmlFragment, "5");
    }

    public static void write(MetaData md, Lexicon lex, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(md, null, lex, outputStream, outputAsXmlFragment, "5");
    }

    public static void write(MetaData md, TextCorpus tc, Lexicon lex, File file, boolean outputAsXmlFragment, String version) throws WLFormatException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            WLDObjector.write(md, tc, lex, outputStream, outputAsXmlFragment, version);
        }
        catch (Exception e) {
            throw new WLFormatException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    throw new WLFormatException(e);
                }
            }
        }
    }

    public static void write(MetaData md, TextCorpus tc, Lexicon lex, OutputStream outputStream, boolean outputAsXmlFragment, String version) throws WLFormatException {
        String xmlModel;
        if (tc == null && lex == null) {
            throw new WLFormatException("cannot write tcf: both textcorpus and lexicon formats are missing");
        }
        if (tc != null && lex != null) {
            throw new WLFormatException("cannot write tcf: both textcorpus and lexicon formats are present, but only one is allowed");
        }
        switch (version) {
            case "5": {
                xmlModel = CommonConstants.XML_WL1_MODEL_PI_CONTENT_FOR_VERSION_5;
                break;
            }
            case "0.4": {
                xmlModel = CommonConstants.XML_WL1_MODEL_PI_CONTENT_FOR_VERSION_04;
                break;
            }
            default: {
                throw new WLFormatException("Unsupported version. Supported versions are 5 and 0.4.");
            }
        }
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        XMLOutputFactory xmlOututFactory = XMLOutputFactory.newInstance();
        XMLEventWriter xmlEventWriter = null;
        try {
            XMLEvent e;
            xmlEventWriter = new IndentingXMLEventWriter(xmlOututFactory.createXMLEventWriter(outputStream, "UTF-8"));
            if (!outputAsXmlFragment) {
                e = eventFactory.createStartDocument("UTF-8");
                xmlEventWriter.add(e);
                e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                xmlEventWriter.add(e);
                e = eventFactory.createProcessingInstruction("xml-model", xmlModel);
                xmlEventWriter.add(e);
                e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                xmlEventWriter.add(e);
            }
            Attribute versionAttr = eventFactory.createAttribute("version", version);
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            attrs.add(versionAttr);
            Namespace ns = eventFactory.createNamespace("http://www.dspin.de/data");
            ArrayList<Namespace> nss = new ArrayList<Namespace>();
            nss.add(ns);
            e = eventFactory.createStartElement("", "http://www.dspin.de/data", "D-Spin", attrs.iterator(), nss.iterator());
            xmlEventWriter.add(e);
            e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
            xmlEventWriter.add(e);
            JAXBContext mdContext = JAXBContext.newInstance((Class[])new Class[]{MetaData.class});
            Marshaller mdMarshaller = mdContext.createMarshaller();
            mdMarshaller.setProperty("jaxb.fragment", (Object)true);
            mdMarshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.clarin.eu/cmd/ http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1320657629623/xsd");
            mdMarshaller.marshal((Object)md, xmlEventWriter);
            e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
            xmlEventWriter.add(e);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{tc != null ? TextCorpusStored.class : LexiconStored.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal(tc != null ? tc : lex, xmlEventWriter);
            e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
            xmlEventWriter.add(e);
            e = eventFactory.createEndElement("", "http://www.dspin.de/data", "D-Spin");
            xmlEventWriter.add(e);
            if (!outputAsXmlFragment) {
                e = eventFactory.createEndDocument();
                xmlEventWriter.add(e);
            }
        }
        catch (Exception ex) {
            throw new WLFormatException(ex.getMessage(), ex);
        }
        finally {
            if (xmlEventWriter != null) {
                try {
                    xmlEventWriter.flush();
                    xmlEventWriter.close();
                }
                catch (XMLStreamException ex2) {
                    throw new WLFormatException(ex2.getMessage(), ex2);
                }
            }
        }
    }
}

