/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.ed.xb;

import eu.clarin.weblicht.wlfxb.ed.api.ExternalDataLayer;
import eu.clarin.weblicht.wlfxb.ed.xb.CanonicalSegmentationLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.NamedEntityModelLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.PhoneticSegmentationLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.SpeechSignalLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.TokenSegmentationLayerStored;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ExternalDataLayerTag {
    SPEECH_SIGNAL("speechsignal", SpeechSignalLayerStored.class),
    TOKEN_SEGMENTATION("tokensegmentation", TokenSegmentationLayerStored.class),
    PHONETIC_SEGMENTATION("phoneticsegmentation", PhoneticSegmentationLayerStored.class),
    CANONICAL_SEGMENTATION("canonicalsegmentation", CanonicalSegmentationLayerStored.class),
    NAMEDENTITY_MODEL("namedentitymodel", NamedEntityModelLayerStored.class);

    private static final Map<String, ExternalDataLayerTag> xmlNameToLayerTagMap;
    private static final Map<Class<? extends ExternalDataLayer>, ExternalDataLayerTag> classToLayerTagMap;
    private static final ExternalDataLayerTag[] layersOrder;
    private final String xmlName;
    private final Class<? extends ExternalDataLayer> layerClass;

    private ExternalDataLayerTag(String name, Class<? extends ExternalDataLayer> layerClass) {
        this.xmlName = name;
        this.layerClass = layerClass;
    }

    public final String getXmlName() {
        return this.xmlName;
    }

    public final Class<? extends ExternalDataLayer> getLayerClass() {
        return this.layerClass;
    }

    public static ExternalDataLayerTag getFromXmlName(String xmlName) {
        return xmlNameToLayerTagMap.get(xmlName);
    }

    public static List<ExternalDataLayerTag> orderedLayerTags() {
        return Arrays.asList(layersOrder);
    }

    public static ExternalDataLayerTag getFromClass(Class<? extends ExternalDataLayer> cl) {
        return classToLayerTagMap.get(cl);
    }

    static {
        xmlNameToLayerTagMap = new HashMap<String, ExternalDataLayerTag>(){
            {
                for (ExternalDataLayerTag layerTag : ExternalDataLayerTag.values()) {
                    this.put(layerTag.xmlName, layerTag);
                }
            }
        };
        classToLayerTagMap = new HashMap<Class<? extends ExternalDataLayer>, ExternalDataLayerTag>(){
            {
                for (ExternalDataLayerTag layerTag : ExternalDataLayerTag.values()) {
                    this.put(layerTag.getLayerClass(), layerTag);
                }
            }
        };
        layersOrder = new ExternalDataLayerTag[ExternalDataLayerTag.values().length];
        ExternalDataLayerTag[] externalDataLayerTagArray = ExternalDataLayerTag.values();
        int n = externalDataLayerTagArray.length;
        for (int i = 0; i < n; ++i) {
            ExternalDataLayerTag layerTag;
            ExternalDataLayerTag.layersOrder[layerTag.ordinal()] = layerTag = externalDataLayerTagArray[i];
        }
    }
}

