/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Orthform;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.api.WordSense;
import eu.clarin.weblicht.wlfxb.tc.api.WordSensesLayer;
import eu.clarin.weblicht.wlfxb.tc.xb.LexicalSemanticsLayerStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.tc.xb.WordSenseStored;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="wsd")
@XmlAccessorType(value=XmlAccessType.NONE)
public class WordSensesLayerStored
extends TextCorpusLayerStoredAbstract
implements WordSensesLayer {
    public static final String XML_NAME = "wsd";
    @XmlAttribute(name="src")
    private String source;
    @XmlElement(name="ws")
    private List<WordSenseStored> senses = new ArrayList<WordSenseStored>();
    private TextCorpusLayersConnector connector;

    protected WordSensesLayerStored() {
    }

    protected WordSensesLayerStored(String source) {
        this.source = source;
    }

    protected WordSensesLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (WordSenseStored ws : this.senses) {
            for (String tokRef : ws.tokRefs) {
                connector.token2ItsWordSense.put(connector.tokenId2ItsToken.get(tokRef), ws);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.senses.isEmpty();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int size() {
        return this.senses.size();
    }

    @Override
    public WordSense getWordSense(int index) {
        return this.senses.get(index);
    }

    @Override
    public WordSense getWordSense(Token token) {
        WordSense ws = this.connector.token2ItsWordSense.get(token);
        return ws;
    }

    @Override
    public Token[] getTokens(WordSense ws) {
        if (ws instanceof WordSenseStored) {
            WordSenseStored sense = (WordSenseStored)ws;
            Token[] tokens = new Token[sense.tokRefs.length];
            for (int i = 0; i < sense.tokRefs.length; ++i) {
                tokens[i] = this.connector.tokenId2ItsToken.get(sense.tokRefs[i]);
            }
            return tokens;
        }
        throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Orthform.class, LexicalSemanticsLayerStored.class));
    }

    @Override
    public WordSense addWordSense(Token token, String ... lexicalUnits) {
        List<Token> tokens = Arrays.asList(token);
        return this.addWordSense(tokens, (String)null, lexicalUnits);
    }

    @Override
    public WordSense addWordSense(List<Token> tokens, String ... lexicalUnits) {
        return this.addWordSense(tokens, (String)null, lexicalUnits);
    }

    @Override
    public WordSense addWordSense(Token token, String comment, String ... lexicalUnits) {
        List<Token> tokens = Arrays.asList(token);
        return this.addWordSense(tokens, comment, lexicalUnits);
    }

    @Override
    public WordSense addWordSense(List<Token> tokens, String comment, String ... lexicalUnits) {
        WordSenseStored ws = new WordSenseStored();
        ws.comment = comment;
        ws.lexunits = new String[lexicalUnits.length];
        System.arraycopy(lexicalUnits, 0, ws.lexunits, 0, lexicalUnits.length);
        ws.tokRefs = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            ws.tokRefs[i] = token.getID();
            this.connector.token2ItsWordSense.put(token, ws);
        }
        this.senses.add(ws);
        return ws;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append("{");
        sb.append(this.source);
        sb.append("}");
        sb.append(" : ");
        sb.append(this.senses.toString());
        return sb.toString();
    }
}

