/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.api.TokensLayer;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.tc.xb.TokenStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="tokens")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TokensLayerStored
extends TextCorpusLayerStoredAbstract
implements TokensLayer {
    public static final String XML_NAME = "tokens";
    private TextCorpusLayersConnector connector;
    @XmlElement(name="token")
    private List<TokenStored> tokens = new ArrayList<TokenStored>();
    @XmlAttribute(name="charOffsets")
    private Boolean charOffsets;

    protected TokensLayerStored() {
    }

    protected TokensLayerStored(Boolean hasCharOffsets) {
        this.charOffsets = hasCharOffsets;
    }

    protected TokensLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (TokenStored token : this.tokens) {
            token.order = this.connector.tokenId2ItsToken.size();
            this.connector.tokenId2ItsToken.put(token.tokenId, token);
        }
        this.connector.tokens = this.tokens;
    }

    @Override
    public Token getToken(int index) {
        Token token = this.tokens.get(index);
        return token;
    }

    @Override
    public Token getToken(String tokenId) {
        Token token = this.connector.tokenId2ItsToken.get(tokenId);
        return token;
    }

    @Override
    public Token addToken(String tokenString) {
        int tokenCount = this.tokens.size();
        String tokenId = "t_" + tokenCount;
        return this.addToken(tokenString, null, null, tokenId);
    }

    @Override
    public Token addToken(String tokenString, String tokenId) {
        return this.addToken(tokenString, null, null, tokenId);
    }

    @Override
    public Token addToken(String tokenString, long start, long end) {
        int tokenCount = this.tokens.size();
        String tokenId = "t_" + tokenCount;
        return this.addToken(tokenString, (Long)start, (Long)end, tokenId);
    }

    @Override
    public Token addToken(String tokenString, long start, long end, String tokenId) {
        return this.addToken(tokenString, (Long)start, (Long)end, tokenId);
    }

    private Token addToken(String tokenString, Long start, Long end, String tokenId) {
        TokenStored token = new TokenStored();
        token.tokenId = tokenId;
        token.tokenString = tokenString;
        if (start != null && end != null) {
            token.start = start;
            this.charOffsets = true;
        }
        token.order = this.tokens.size();
        this.connector.tokenId2ItsToken.put(token.tokenId, token);
        this.tokens.add(token);
        return token;
    }

    @Override
    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public boolean hasCharOffsets() {
        if (this.charOffsets == null) {
            return false;
        }
        return this.charOffsets;
    }

    protected void beforeMarshal(Marshaller m) {
        this.setFalseAttrToNull();
    }

    private void setFalseAttrToNull() {
        if (this.charOffsets == Boolean.FALSE) {
            this.charOffsets = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        if (this.hasCharOffsets()) {
            sb.append("charOffsets").append(" ").append(Boolean.toString(this.charOffsets));
        }
        sb.append("}: ");
        sb.append(this.tokens.toString());
        return sb.toString();
    }
}

