/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.TextSpan;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="textspan")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TextSpanStored
implements TextSpan {
    public static final String XML_NAME = "textspan";
    @XmlAttribute(name="startChar")
    protected Integer startChar;
    @XmlAttribute(name="endChar")
    protected Integer endChar;
    @XmlAttribute(name="start")
    protected String startToken;
    @XmlAttribute(name="end")
    protected String endToken;
    @XmlAttribute(name="type")
    protected String type;
    protected String value;
    protected List<TextSpanStored> subspans;
    private List<Object> content = new ArrayList<Object>();

    @XmlMixed
    @XmlElementRefs(value={@XmlElementRef(name="textspan", type=TextSpanStored.class)})
    protected List<Object> getContent() {
        ArrayList<Object> contentToMarshal = new ArrayList<Object>();
        if (this.subspans != null) {
            contentToMarshal.addAll(this.subspans);
        } else if (this.value != null) {
            contentToMarshal.add(this.value);
        } else {
            return null;
        }
        return contentToMarshal;
    }

    void setContent(List<Object> content) {
        this.content = content;
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        for (Object obj : this.content) {
            if (obj instanceof String) {
                String v = ((String)obj).trim();
                if (this.subspans != null || v.length() <= 0) continue;
                this.value = v;
                return;
            }
            if (!(obj instanceof TextSpanStored)) continue;
            if (this.subspans == null) {
                this.subspans = new ArrayList<TextSpanStored>();
            }
            this.subspans.add((TextSpanStored)obj);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isTerminal() {
        return this.subspans == null || this.subspans.isEmpty();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public TextSpanStored[] getSubspans() {
        if (this.subspans == null) {
            return null;
        }
        return this.subspans.toArray(new TextSpanStored[this.subspans.size()]);
    }

    @Override
    public Integer getStartChar() {
        return this.startChar;
    }

    @Override
    public Integer getEndChar() {
        return this.endChar;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(this.type);
            sb.append(" ");
        }
        if (this.startToken != null && this.endToken != null) {
            sb.append(" ");
            sb.append(this.startToken);
            sb.append(" - ");
            sb.append(this.endToken);
        }
        if (this.startChar != null && this.endChar != null) {
            sb.append(" ");
            sb.append(this.startChar);
            sb.append(" - ");
            sb.append(this.endChar);
        }
        if (this.isTerminal()) {
            sb.append(this.value);
        } else if (this.subspans != null && !this.subspans.isEmpty()) {
            sb.append(this.subspans.toString());
        }
        return sb.toString();
    }
}

