/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Lemma;
import eu.clarin.weblicht.wlfxb.tc.api.LexicalSemanticsLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Orthform;
import eu.clarin.weblicht.wlfxb.tc.xb.LemmaStored;
import eu.clarin.weblicht.wlfxb.tc.xb.LemmasLayerStored;
import eu.clarin.weblicht.wlfxb.tc.xb.OrthformStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class LexicalSemanticsLayerStored
extends TextCorpusLayerStoredAbstract
implements LexicalSemanticsLayer {
    @XmlElement(name="orthform")
    protected List<OrthformStored> orthforms = new ArrayList<OrthformStored>();
    protected TextCorpusLayersConnector connector;
    private Map<String, OrthformStored> orthformValue2Orthform = new HashMap<String, OrthformStored>();

    protected LexicalSemanticsLayerStored() {
    }

    protected LexicalSemanticsLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.orthforms.isEmpty();
    }

    @Override
    public int size() {
        return this.orthforms.size();
    }

    @Override
    public Orthform getOrthform(int index) {
        return this.orthforms.get(index);
    }

    @Override
    public Lemma[] getLemmas(Orthform orthform) {
        if (orthform instanceof OrthformStored) {
            OrthformStored orth = (OrthformStored)orthform;
            Lemma[] lemmas = new Lemma[orth.lemmaRefs.length];
            for (int i = 0; i < orth.lemmaRefs.length; ++i) {
                lemmas[i] = this.connector.lemmaId2ItsLemma.get(orth.lemmaRefs[i]);
            }
            return lemmas;
        }
        throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Orthform.class, LexicalSemanticsLayerStored.class));
    }

    @Override
    public Orthform addOrthform(String orthformValues, Lemma lemma) {
        OrthformStored orthform;
        LemmaStored lem = null;
        if (!(lemma instanceof LemmaStored)) {
            throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Lemma.class, LemmasLayerStored.class));
        }
        lem = (LemmaStored)lemma;
        if (!this.orthformValue2Orthform.containsKey(orthformValues)) {
            orthform = new OrthformStored();
            orthform.values = orthformValues;
            this.orthformValue2Orthform.put(orthformValues, orthform);
            this.orthforms.add(orthform);
        }
        orthform = this.orthformValue2Orthform.get(orthformValues);
        this.addLemma(orthform, lem);
        return orthform;
    }

    @Override
    public Orthform addOrthform(String[] orthformValues, Lemma lemma) {
        String values = Arrays.toString(orthformValues);
        return this.addOrthform(values.substring(1, values.length() - 1), lemma);
    }

    private void addLemma(OrthformStored orthform, LemmaStored lemma) {
        if (orthform.lemmaRefs == null) {
            orthform.lemmaRefs = new String[]{lemma.lemmaId};
        } else {
            orthform.lemmaRefs = Arrays.copyOf(orthform.lemmaRefs, orthform.lemmaRefs.length + 1);
            orthform.lemmaRefs[orthform.lemmaRefs.length - 1] = lemma.lemmaId;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" : ");
        sb.append(this.orthforms.toString());
        return sb.toString();
    }
}

