/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.EntriesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.Entry;
import eu.clarin.weblicht.wlfxb.lx.api.EntryType;
import eu.clarin.weblicht.wlfxb.lx.xb.EntryStored;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="entries")
@XmlAccessorType(value=XmlAccessType.NONE)
public class EntriesLayerStored
extends LexiconLayerStoredAbstract
implements EntriesLayer {
    public static final String XML_NAME = "entries";
    private LexiconLayersConnector connector;
    @XmlAttribute(name="type")
    private EntryType entryType;
    @XmlElement(name="entry")
    private List<EntryStored> entries = new ArrayList<EntryStored>();

    protected EntriesLayerStored() {
    }

    protected EntriesLayerStored(EntryType type) {
        this.entryType = type;
    }

    protected EntriesLayerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
        for (EntryStored entry : this.entries) {
            this.connector.entryId2ItsEntry.put(entry.entryId, entry);
        }
    }

    @Override
    public EntryType getType() {
        return this.entryType;
    }

    @Override
    public Entry getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public Entry getEntry(String entryId) {
        Entry entry = this.connector.entryId2ItsEntry.get(entryId);
        return entry;
    }

    @Override
    public Entry addEntry(String entryString) {
        EntryStored entry = new EntryStored();
        int entryCount = this.entries.size();
        entry.entryId = "e_" + entryCount;
        entry.entryString = entryString;
        this.connector.entryId2ItsEntry.put(entry.entryId, entry);
        this.entries.add(entry);
        return entry;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" ");
        sb.append((Object)this.entryType);
        sb.append(" : ");
        sb.append(this.entries.toString());
        return sb.toString();
    }
}

