/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.io;

import eu.clarin.weblicht.wlfxb.ed.api.ExternalData;
import eu.clarin.weblicht.wlfxb.ed.api.ExternalDataLayer;
import eu.clarin.weblicht.wlfxb.ed.xb.ExternalDataLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.ExternalDataLayerTag;
import eu.clarin.weblicht.wlfxb.ed.xb.ExternalDataStored;
import eu.clarin.weblicht.wlfxb.io.WLFormatException;
import eu.clarin.weblicht.wlfxb.io.XmlReaderWriter;
import eu.clarin.weblicht.wlfxb.tc.api.TextCorpus;
import eu.clarin.weblicht.wlfxb.tc.api.TextCorpusLayer;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerTag;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusStored;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;

public class ExternalDataWithTextCorpusStreamed {
    private EnumSet<ExternalDataLayerTag> edLayersToRead = EnumSet.noneOf(ExternalDataLayerTag.class);
    private EnumSet<TextCorpusLayerTag> tcLayersToRead = EnumSet.noneOf(TextCorpusLayerTag.class);
    private TextCorpusStored textCorpus;
    private boolean hasTextCorpus = false;
    private ExternalDataStored extData;
    private boolean hasExtData = false;
    private XMLEventReader xmlEventReader;
    private File tempFile;
    private XMLEventWriter xmlEventWriter;
    private XmlReaderWriter xmlReaderWriter;
    private static final int LAYER_INDENT_RELATIVE = 1;
    private boolean closed = false;

    public ExternalDataWithTextCorpusStreamed(InputStream inputStream, EnumSet<ExternalDataLayerTag> edLayersToRead, EnumSet<TextCorpusLayerTag> tcLayersToRead) throws WLFormatException {
        this.getLayersToReadWithDependencies(edLayersToRead, tcLayersToRead);
        this.extData = new ExternalDataStored();
        this.textCorpus = new TextCorpusStored("unknown");
        try {
            this.initializeReaderAndWriter(inputStream, null, false);
            this.readLayers();
        }
        catch (WLFormatException e) {
            Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, e);
            this.cleanup();
            throw e;
        }
    }

    public ExternalDataWithTextCorpusStreamed(InputStream inputStream, EnumSet<ExternalDataLayerTag> edLayersToRead, EnumSet<TextCorpusLayerTag> tcLayersToRead, OutputStream outputStream) throws WLFormatException {
        this.extData = new ExternalDataStored();
        this.textCorpus = new TextCorpusStored("unknown");
        this.getLayersToReadWithDependencies(edLayersToRead, tcLayersToRead);
        OutputStream osTemp = null;
        InputStream isTemp = null;
        try {
            osTemp = this.getTempOutputStream();
            this.initializeReaderAndWriter(inputStream, osTemp, false);
            this.readLayers();
            isTemp = this.getTempInputStream();
            this.initializeReaderAndWriter(isTemp, outputStream, false);
        }
        catch (WLFormatException e) {
            Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, e);
            this.cleanup();
            throw e;
        }
    }

    public TextCorpus getTextCorpus() {
        return this.textCorpus;
    }

    public ExternalData getExternalData() {
        return this.extData;
    }

    private OutputStream getTempOutputStream() throws WLFormatException {
        FileOutputStream os = null;
        try {
            this.tempFile = File.createTempFile("wlftemp", null);
            os = new FileOutputStream(this.tempFile);
        }
        catch (IOException e) {
            Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, e);
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.cleanup();
            throw new WLFormatException(e);
        }
        return os;
    }

    private InputStream getTempInputStream() throws WLFormatException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.tempFile);
        }
        catch (IOException e) {
            Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, e);
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.cleanup();
            throw new WLFormatException(e);
        }
        return is;
    }

    private void initializeReaderAndWriter(InputStream inputStream, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        if (inputStream != null) {
            try {
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                this.xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream, "UTF-8");
            }
            catch (XMLStreamException e) {
                throw new WLFormatException(e.getMessage(), e);
            }
        }
        if (outputStream != null) {
            try {
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                this.xmlEventWriter = new IndentingXMLEventWriter(xmlOutputFactory.createXMLEventWriter(outputStream, "UTF-8"));
            }
            catch (XMLStreamException e) {
                throw new WLFormatException(e.getMessage(), e);
            }
        }
        this.xmlReaderWriter = new XmlReaderWriter(this.xmlEventReader, this.xmlEventWriter);
        this.xmlReaderWriter.setOutputAsXmlFragment(outputAsXmlFragment);
    }

    private void readLayers() throws WLFormatException {
        this.readUpToExtDataOrTextCorpus();
        if (this.hasExtData) {
            this.readExternalDataLayers();
        }
        this.readUpToExtDataOrTextCorpus();
        if (this.hasTextCorpus) {
            this.readTextCorpusLayers();
        }
        this.xmlReaderWriter.readWriteToTheEnd();
    }

    private void readUpToExtDataOrTextCorpus() throws WLFormatException {
        try {
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            while (!this.hasExtData || !this.hasTextCorpus) {
                if (peekedEvent.getEventType() == 1 && ((peekedEvent.asStartElement().getName().getLocalPart() != null ? peekedEvent.asStartElement().getName().getLocalPart().equals("ExternalData") : "ExternalData" == null) || (peekedEvent.asStartElement().getName().getLocalPart() == null ? "TextCorpus" == null : peekedEvent.asStartElement().getName().getLocalPart().equals("TextCorpus")))) {
                    if (peekedEvent.asStartElement().getName().getLocalPart() == null ? "ExternalData" == null : peekedEvent.asStartElement().getName().getLocalPart().equals("ExternalData")) {
                        this.hasExtData = true;
                    } else if (peekedEvent.asStartElement().getName().getLocalPart() == null ? "TextCorpus" == null : peekedEvent.asStartElement().getName().getLocalPart().equals("TextCorpus")) {
                        this.hasTextCorpus = true;
                    }
                    return;
                }
                XMLEvent readEvent = this.xmlReaderWriter.readEvent();
                this.xmlReaderWriter.add(readEvent);
                peekedEvent = this.xmlEventReader.peek();
            }
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    private void readExternalDataLayers() throws WLFormatException {
        try {
            this.xmlReaderWriter.readWriteUpToStartElement("ExternalData");
            XMLEvent event = this.xmlEventReader.nextEvent();
            this.xmlReaderWriter.add(event);
            ExternalDataLayerStored[] layers = new ExternalDataLayerStored[this.edLayersToRead.size()];
            int counter = 0;
            boolean extDataEnd = false;
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            while (!extDataEnd && peekedEvent != null) {
                if (peekedEvent.getEventType() == 2 && peekedEvent.asEndElement().getName().getLocalPart().equals("ExternalData")) {
                    extDataEnd = true;
                    continue;
                }
                if (peekedEvent.getEventType() == 1 && this.edLayersToRead.contains((Object)ExternalDataLayerTag.getFromXmlName(peekedEvent.asStartElement().getName().getLocalPart()))) {
                    ExternalDataLayerStored layer = this.readExternalDataLayer();
                    layers[counter++] = layer;
                    peekedEvent = this.xmlEventReader.peek();
                    continue;
                }
                XMLEvent readEvent = this.xmlReaderWriter.readEvent();
                this.xmlReaderWriter.add(readEvent);
                peekedEvent = this.xmlEventReader.peek();
            }
            if (!extDataEnd) {
                throw new WLFormatException("ExternalData end tag not found");
            }
            this.extData = ExternalDataStored.compose(layers);
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    private ExternalDataLayerStored readExternalDataLayer() throws WLFormatException {
        ExternalDataLayerStored layer = null;
        try {
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            String tagName = peekedEvent.asStartElement().getName().getLocalPart();
            ExternalDataLayerTag layerTag = ExternalDataLayerTag.getFromXmlName(tagName);
            if (layerTag == null) {
                this.xmlReaderWriter.readWriteElement(tagName);
            } else if (this.edLayersToRead.contains((Object)layerTag)) {
                layer = this.readExternalLayerData(layerTag);
            } else {
                this.xmlReaderWriter.readWriteElement(tagName);
            }
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return layer;
    }

    private ExternalDataLayerStored readExternalLayerData(ExternalDataLayerTag layerTag) throws WLFormatException {
        ExternalDataLayerStored layer;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{layerTag.getLayerClass()});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            layer = (ExternalDataLayerStored)unmarshaller.unmarshal(this.xmlEventReader);
            this.marshall(layer);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return layer;
    }

    private void readTextCorpusLayers() throws WLFormatException {
        try {
            this.xmlReaderWriter.readWriteUpToStartElement("TextCorpus");
            XMLEvent event = this.xmlEventReader.nextEvent();
            String lang = event.asStartElement().getAttributeByName(new QName("lang")).getValue();
            this.xmlReaderWriter.add(event);
            Object[] layers = new TextCorpusLayerStoredAbstract[this.tcLayersToRead.size()];
            int counter = 0;
            boolean tcEnd = false;
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            while (!tcEnd && peekedEvent != null) {
                if (peekedEvent.getEventType() == 2 && peekedEvent.asEndElement().getName().getLocalPart().equals("TextCorpus")) {
                    tcEnd = true;
                    continue;
                }
                if (peekedEvent.getEventType() == 1 && this.tcLayersToRead.contains((Object)TextCorpusLayerTag.getFromXmlName(peekedEvent.asStartElement().getName().getLocalPart()))) {
                    TextCorpusLayerStoredAbstract layer = this.readTextCorpusLayer();
                    layers[counter++] = layer;
                    peekedEvent = this.xmlEventReader.peek();
                    continue;
                }
                XMLEvent readEvent = this.xmlReaderWriter.readEvent();
                this.xmlReaderWriter.add(readEvent);
                peekedEvent = this.xmlEventReader.peek();
            }
            if (!tcEnd) {
                throw new WLFormatException("TextCorpus end tag not found");
            }
            if (!this.filled(layers)) {
                throw new WLFormatException("TextCorpus not all requested layers are found");
            }
            this.textCorpus = TextCorpusStored.compose(lang, (TextCorpusLayerStoredAbstract[])layers);
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    private boolean filled(Object[] layers) {
        for (Object o : layers) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    private TextCorpusLayerStoredAbstract readTextCorpusLayer() throws WLFormatException {
        TextCorpusLayerStoredAbstract layer = null;
        try {
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            String tagName = peekedEvent.asStartElement().getName().getLocalPart();
            TextCorpusLayerTag layerTag = TextCorpusLayerTag.getFromXmlName(tagName);
            if (layerTag == null) {
                this.xmlReaderWriter.readWriteElement(tagName);
            } else if (this.tcLayersToRead.contains((Object)layerTag)) {
                layer = this.readTextCorpusLayerData(layerTag);
            } else {
                this.xmlReaderWriter.readWriteElement(tagName);
            }
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return layer;
    }

    private TextCorpusLayerStoredAbstract readTextCorpusLayerData(TextCorpusLayerTag layerTag) throws WLFormatException {
        TextCorpusLayerStoredAbstract layer = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{layerTag.getLayerClass()});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            layer = (TextCorpusLayerStoredAbstract)unmarshaller.unmarshal(this.xmlEventReader);
            this.marshall(layer);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return layer;
    }

    private void marshall(Object layer) throws WLFormatException {
        if (this.xmlEventWriter == null) {
            return;
        }
        try {
            this.xmlReaderWriter.startExternalFragment(1);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{layer.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(layer, this.xmlEventWriter);
            this.xmlReaderWriter.endExternalFragment(1);
        }
        catch (Exception e) {
            Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, e);
            this.cleanup();
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    public void close() throws WLFormatException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        try {
            if (this.xmlEventWriter != null) {
                XMLEvent e;
                if (!this.hasExtData) {
                    this.xmlReaderWriter.readWriteUpToStartElement("TextCorpus");
                    ArrayList attrs = new ArrayList(0);
                    Namespace ns = eventFactory.createNamespace("http://www.dspin.de/data/extdata");
                    ArrayList<Namespace> nss = new ArrayList<Namespace>();
                    nss.add(ns);
                    e = eventFactory.createStartElement("", "http://www.dspin.de/data/extdata", "ExternalData", attrs.iterator(), nss.iterator());
                    this.xmlEventWriter.add(e);
                    e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                    this.xmlEventWriter.add(e);
                } else {
                    this.xmlReaderWriter.readWriteUpToEndElement("ExternalData");
                }
                List<ExternalDataLayer> edLayers = this.extData.getLayers();
                for (ExternalDataLayer layer : edLayers) {
                    if (this.edLayersToRead.contains((Object)ExternalDataLayerTag.getFromClass(layer.getClass()))) continue;
                    this.marshall(layer);
                }
                if (!this.hasExtData) {
                    e = eventFactory.createEndElement("", "http://www.dspin.de/data/extdata", "ExternalData");
                    this.xmlEventWriter.add(e);
                    e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                    this.xmlEventWriter.add(e);
                }
                if (!this.hasTextCorpus) {
                    this.xmlReaderWriter.readWriteUpToStartElement("D-Spin");
                    ArrayList attrs = new ArrayList(0);
                    Namespace ns = eventFactory.createNamespace("http://www.dspin.de/data/textcorpus");
                    ArrayList<Namespace> nss = new ArrayList<Namespace>();
                    nss.add(ns);
                    e = eventFactory.createStartElement("", "http://www.dspin.de/data/textcorpus", "TextCorpus", attrs.iterator(), nss.iterator());
                    this.xmlEventWriter.add(e);
                    e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                    this.xmlEventWriter.add(e);
                } else {
                    this.xmlReaderWriter.readWriteUpToEndElement("TextCorpus");
                }
                List<TextCorpusLayer> tcLayers = this.textCorpus.getLayers();
                for (TextCorpusLayer layer : tcLayers) {
                    if (this.tcLayersToRead.contains((Object)TextCorpusLayerTag.getFromClass(layer.getClass()))) continue;
                    this.marshall(layer);
                }
                if (!this.hasTextCorpus) {
                    e = eventFactory.createEndElement("", "http://www.dspin.de/data/textcorpus", "TextCorpus");
                    this.xmlEventWriter.add(e);
                    e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                    this.xmlEventWriter.add(e);
                }
                this.xmlReaderWriter.readWriteToTheEnd();
            }
        }
        catch (XMLStreamException ex) {
            throw new WLFormatException(ex.getMessage(), ex);
        }
        finally {
            this.cleanup();
        }
    }

    public String toString() {
        return this.extData.toString() + "\n" + this.textCorpus.toString();
    }

    private void cleanup() {
        if (this.xmlEventWriter != null) {
            try {
                this.xmlEventWriter.close();
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.xmlEventReader != null) {
            try {
                this.xmlEventReader.close();
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.xmlReaderWriter != null) {
            try {
                this.xmlReaderWriter.close();
            }
            catch (WLFormatException ex) {
                Logger.getLogger(ExternalDataWithTextCorpusStreamed.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    private void getLayersToReadWithDependencies(EnumSet<ExternalDataLayerTag> edLayersToRead, EnumSet<TextCorpusLayerTag> tcLayersToRead) {
        if (edLayersToRead != null) {
            this.edLayersToRead = EnumSet.copyOf(edLayersToRead);
        }
        if (tcLayersToRead != null) {
            this.tcLayersToRead = EnumSet.copyOf(tcLayersToRead);
            for (TextCorpusLayerTag tag : tcLayersToRead) {
                this.tcLayersToRead.addAll(tag.withDependentLayers());
            }
        }
    }
}

