/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.io.WLFormatException;
import eu.clarin.weblicht.wlfxb.tc.api.OrthographyLayer;
import eu.clarin.weblicht.wlfxb.tc.api.TextSpan;
import eu.clarin.weblicht.wlfxb.tc.api.TextStructureLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.tc.xb.TextSpanStored;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="textstructure")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TextStructureLayerStored
extends TextCorpusLayerStoredAbstract
implements TextStructureLayer {
    public static final String XML_NAME = "textstructure";
    @XmlElement(name="textspan")
    private List<TextSpanStored> tspans = new ArrayList<TextSpanStored>();
    private TextCorpusLayersConnector connector;

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (int i = 0; i < this.tspans.size(); ++i) {
            this.addToConnector(this.tspans.get(i), connector);
        }
    }

    private void addToConnector(TextSpanStored tspan, TextCorpusLayersConnector connector) {
        String type = tspan.getType();
        if (!connector.token2ItsTextSpans.containsKey(type)) {
            connector.token2ItsTextSpans.put(type, new HashMap());
        }
        if (tspan.startToken != null && tspan.endToken != null) {
            int start = connector.tokenId2ItsToken.get(tspan.startToken).getOrder();
            int end = connector.tokenId2ItsToken.get(tspan.endToken).getOrder() + 1;
            for (int j = start; j < end; ++j) {
                connector.token2ItsTextSpans.get(type).put(connector.tokens.get(j), tspan);
            }
            if (tspan.getSubspans() != null) {
                for (TextSpanStored subspan : tspan.getSubspans()) {
                    this.addToConnector(subspan, connector);
                }
            }
        }
    }

    protected TextStructureLayerStored() {
    }

    protected TextStructureLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.tspans.isEmpty();
    }

    @Override
    public int size() {
        return this.tspans.size();
    }

    @Override
    public TextSpan getSpan(int index) {
        return this.tspans.get(index);
    }

    @Override
    public List<TextSpan> getSpans(Token token) {
        ArrayList<TextSpan> spans = new ArrayList<TextSpan>();
        for (String type : this.connector.token2ItsTextSpans.keySet()) {
            Map<Token, TextSpan> tokToSpan = this.connector.token2ItsTextSpans.get(type);
            TextSpan span = tokToSpan.get(token);
            if (span == null) continue;
            spans.add(span);
        }
        return spans;
    }

    @Override
    public TextSpan getSpan(Token token, String type) {
        TextSpan span = null;
        Map<Token, TextSpan> tokToSpan = this.connector.token2ItsTextSpans.get(type);
        if (tokToSpan != null) {
            span = tokToSpan.get(token);
        }
        return span;
    }

    @Override
    public List<TextSpan> getSpans(String type) {
        ArrayList<TextSpan> spans = new ArrayList<TextSpan>();
        Map<Token, TextSpan> tokToSpan = this.connector.token2ItsTextSpans.get(type);
        if (tokToSpan != null) {
            spans.addAll(tokToSpan.values());
        }
        return spans;
    }

    @Override
    public Token[] getTokens(TextSpan span) {
        if (span instanceof TextSpanStored) {
            TextSpanStored tspan = (TextSpanStored)span;
            if (tspan.startToken != null && tspan.startToken != null) {
                int start = this.connector.tokenId2ItsToken.get(tspan.startToken).getOrder();
                int end = this.connector.tokenId2ItsToken.get(tspan.endToken).getOrder() + 1;
                Token[] tokens = new Token[end - start];
                int i = 0;
                for (int j = start; j < end; ++j) {
                    tokens[i] = this.connector.tokens.get(j);
                    ++i;
                }
                return tokens;
            }
            return new Token[0];
        }
        throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(TextSpan.class, OrthographyLayer.class));
    }

    @Override
    public TextSpan addSpan(Token spanStart, Token spanEnd, String type) {
        return this.addSpan(spanStart, spanEnd, type, null);
    }

    @Override
    public TextSpan addSpan(Token spanStart, Token spanEnd, String type, String value) {
        TextSpanStored tspan = this.createTextSpan(spanStart, spanEnd, type, value);
        this.tspans.add(tspan);
        return tspan;
    }

    @Override
    public TextSpan addSpan(TextSpan parentSpan, Token spanStart, Token spanEnd, String type) throws WLFormatException {
        return this.addSpan(parentSpan, spanStart, spanEnd, type, null);
    }

    @Override
    public TextSpan addSpan(TextSpan parentSpan, Token spanStart, Token spanEnd, String type, String value) throws WLFormatException {
        TextSpanStored tspan = this.createTextSpan(spanStart, spanEnd, type, value);
        if (parentSpan == null) {
            this.tspans.add(tspan);
        } else {
            if (parentSpan.getValue() != null) {
                throw new WLFormatException("The parent " + TextSpan.class.getSimpleName() + " already has value: " + parentSpan.getValue() + ". The " + TextSpan.class.getSimpleName() + "that has value cannot additionally have " + TextSpan.class.getSimpleName() + " subelements");
            }
            if (parentSpan instanceof TextSpanStored) {
                TextSpanStored parentSpanStored = (TextSpanStored)parentSpan;
                if (parentSpanStored.subspans == null) {
                    parentSpanStored.subspans = new ArrayList<TextSpanStored>();
                }
                parentSpanStored.subspans.add(tspan);
            }
        }
        return tspan;
    }

    private TextSpanStored createTextSpan(Token spanStart, Token spanEnd, String type, String value) {
        TextSpanStored tspan = new TextSpanStored();
        tspan.type = type;
        tspan.value = value;
        if (spanStart != null && spanEnd != null) {
            tspan.startToken = spanStart.getID();
            tspan.endToken = spanEnd.getID();
            int start = this.connector.tokenId2ItsToken.get(tspan.startToken).getOrder();
            int end = this.connector.tokenId2ItsToken.get(tspan.endToken).getOrder() + 1;
            for (int j = start; j < end; ++j) {
                if (!this.connector.token2ItsTextSpans.containsKey(type)) {
                    this.connector.token2ItsTextSpans.put(type, new HashMap());
                }
                this.connector.token2ItsTextSpans.get(type).put(this.connector.tokens.get(j), tspan);
            }
        }
        return tspan;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(": ");
        sb.append(this.tspans.toString());
        return sb.toString();
    }
}

