/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Sentence;
import eu.clarin.weblicht.wlfxb.tc.api.SentencesLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.SentenceStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="sentences")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SentencesLayerStored
extends TextCorpusLayerStoredAbstract
implements SentencesLayer {
    public static final String XML_NAME = "sentences";
    @XmlElement(name="sentence", type=SentenceStored.class)
    protected List<SentenceStored> sentences = new ArrayList<SentenceStored>();
    @XmlAttribute(name="charOffsets")
    protected Boolean charOffsets;
    private TextCorpusLayersConnector connector;

    protected SentencesLayerStored() {
    }

    protected SentencesLayerStored(Boolean hasCharOffsets) {
        this.charOffsets = hasCharOffsets;
    }

    protected SentencesLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (SentenceStored sentence : this.sentences) {
            for (String tokRef : sentence.tokIds) {
                connector.token2ItsSentence.put(connector.tokenId2ItsToken.get(tokRef), sentence);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.sentences.isEmpty();
    }

    @Override
    public int size() {
        return this.sentences.size();
    }

    @Override
    public boolean hasCharOffsets() {
        if (this.charOffsets == null) {
            return false;
        }
        return this.charOffsets;
    }

    @Override
    public Sentence getSentence(int index) {
        return this.sentences.get(index);
    }

    @Override
    public Sentence getSentence(Token token) {
        Sentence sentence = this.connector.token2ItsSentence.get(token);
        return sentence;
    }

    @Override
    public Token[] getTokens(Sentence sentence) {
        if (sentence instanceof SentenceStored) {
            SentenceStored sStored = (SentenceStored)sentence;
            return WlfUtilities.tokenIdsToTokens(sStored.tokIds, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public Sentence addSentence(List<Token> sentenceTokens) {
        return this.addSentence(sentenceTokens, null, null);
    }

    @Override
    public Sentence addSentence(List<Token> sentenceTokens, int start, int end) {
        return this.addSentence(sentenceTokens, (Integer)start, (Integer)end);
    }

    public Sentence addSentence(List<Token> sentenceTokens, Integer start, Integer end) {
        SentenceStored sentence = new SentenceStored();
        sentence.tokIds = new String[sentenceTokens.size()];
        if (start != null && end != null) {
            sentence.start = start;
            sentence.end = end;
            this.charOffsets = true;
        }
        for (int i = 0; i < sentenceTokens.size(); ++i) {
            Token sentenceToken = sentenceTokens.get(i);
            sentence.tokIds[i] = sentenceToken.getID();
            this.connector.token2ItsSentence.put(sentenceToken, sentence);
        }
        this.sentences.add(sentence);
        return sentence;
    }

    protected boolean beforeMarshal(Marshaller m) {
        this.setFalseAttrToNull();
        return true;
    }

    private void setFalseAttrToNull() {
        if (this.charOffsets == Boolean.FALSE) {
            this.charOffsets = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        if (this.hasCharOffsets()) {
            sb.append("charOffsets").append(" ").append(Boolean.toString(this.charOffsets));
        }
        sb.append("}: ");
        sb.append(this.sentences.toString());
        return sb.toString();
    }
}

