/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.DiscourseConnective;
import eu.clarin.weblicht.wlfxb.tc.api.DiscourseConnectivesLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.DiscourseConnectiveStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="discourseconnectives")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DiscourseConnectivesLayerStored
extends TextCorpusLayerStoredAbstract
implements DiscourseConnectivesLayer {
    public static final String XML_NAME = "discourseconnectives";
    @XmlElement(name="connective", type=DiscourseConnectiveStored.class)
    private List<DiscourseConnectiveStored> connectives = new ArrayList<DiscourseConnectiveStored>();
    @XmlAttribute(name="tagset")
    private String typesTagset;
    private TextCorpusLayersConnector connector;

    protected DiscourseConnectivesLayerStored() {
    }

    protected DiscourseConnectivesLayerStored(String typesTagset) {
        this.typesTagset = typesTagset;
    }

    protected DiscourseConnectivesLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (DiscourseConnectiveStored connective : this.connectives) {
            for (String tokRef : connective.tokRefs) {
                connector.token2ItsDConnective.put(connector.tokenId2ItsToken.get(tokRef), connective);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.connectives.isEmpty();
    }

    @Override
    public int size() {
        return this.connectives.size();
    }

    @Override
    public String getTypesTagset() {
        return this.typesTagset;
    }

    @Override
    public DiscourseConnective getConnective(int index) {
        return this.connectives.get(index);
    }

    @Override
    public DiscourseConnective getConnective(Token token) {
        DiscourseConnective connective = this.connector.token2ItsDConnective.get(token);
        return connective;
    }

    @Override
    public Token[] getTokens(DiscourseConnective connective) {
        if (connective instanceof DiscourseConnectiveStored) {
            DiscourseConnectiveStored cStored = (DiscourseConnectiveStored)connective;
            return WlfUtilities.tokenIdsToTokens(cStored.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public DiscourseConnective addConnective(List<Token> connectiveTokens) {
        return this.addConnective(connectiveTokens, null);
    }

    @Override
    public DiscourseConnective addConnective(List<Token> connectiveTokens, String semanticType) {
        DiscourseConnectiveStored connective = new DiscourseConnectiveStored();
        connective.tokRefs = new String[connectiveTokens.size()];
        connective.type = semanticType;
        for (int i = 0; i < connectiveTokens.size(); ++i) {
            Token cToken = connectiveTokens.get(i);
            connective.tokRefs[i] = cToken.getID();
            this.connector.token2ItsDConnective.put(cToken, connective);
        }
        this.connectives.add(connective);
        return connective;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        if (this.typesTagset != null) {
            sb.append("tagset").append(" ").append(this.typesTagset);
        }
        sb.append("}: ");
        sb.append(this.connectives.toString());
        return sb.toString();
    }
}

