/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.CooccurrencesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.EntriesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.EntryType;
import eu.clarin.weblicht.wlfxb.lx.api.FrequenciesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.FrequencyType;
import eu.clarin.weblicht.wlfxb.lx.api.Lexicon;
import eu.clarin.weblicht.wlfxb.lx.api.PosTagsLayer;
import eu.clarin.weblicht.wlfxb.lx.api.SyllabificationsLayer;
import eu.clarin.weblicht.wlfxb.lx.api.SynonymsLayer;
import eu.clarin.weblicht.wlfxb.lx.xb.CooccurrencesLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.EntriesLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.FrequenciesLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerTag;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.PosTagsLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.SyllabificationsLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.SynonymsLayerStored;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Lexicon", namespace="http://www.dspin.de/data/lexicon")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"entriesLayer", "posTagsLayer", "frequenciesLayer", "cooccurrencesLayer", "synonymsLayer", "syllabificationsLayer"})
public class LexiconStored
implements Lexicon {
    public static final String XML_NAME = "Lexicon";
    public static final String XML_NAMESPACE = "http://www.dspin.de/data/lexicon";
    @XmlAttribute
    protected String lang;
    protected LexiconLayerStoredAbstract[] layersInOrder;
    private LexiconLayersConnector connector = new LexiconLayersConnector();

    LexiconStored() {
        this.layersInOrder = new LexiconLayerStoredAbstract[LexiconLayerTag.orderedLayerTags().size()];
    }

    public LexiconStored(String language) {
        this();
        this.lang = language;
    }

    public String getLanguage() {
        return this.lang;
    }

    @Override
    public EntriesLayer createEntriesLayer(EntryType entryType) {
        return this.initializeLayer(EntriesLayerStored.class, new Object[]{entryType});
    }

    @Override
    public PosTagsLayer createPosTagsLayer(String tagset) {
        return this.initializeLayer(PosTagsLayerStored.class, tagset);
    }

    @Override
    public FrequenciesLayer createFrequenciesLayer(FrequencyType freqType) {
        return this.initializeLayer(FrequenciesLayerStored.class, new Object[]{freqType});
    }

    @Override
    public CooccurrencesLayer createCooccurrencesLayer() {
        return this.initializeLayer(CooccurrencesLayerStored.class, new Object[0]);
    }

    @Override
    public SynonymsLayer createSynonymsLayer() {
        return this.initializeLayer(SynonymsLayerStored.class, new Object[0]);
    }

    @Override
    public SyllabificationsLayer createSyllabificationsLayer() {
        return this.initializeLayer(SyllabificationsLayerStored.class, new Object[0]);
    }

    private <T extends LexiconLayerStoredAbstract> T initializeLayer(Class<T> layerClass, Object ... params) {
        Class[] paramsClass = null;
        if (params != null) {
            paramsClass = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramsClass[i] = params[i].getClass();
            }
        }
        LexiconLayerTag layerTag = LexiconLayerTag.getFromClass(layerClass);
        try {
            LexiconLayerStoredAbstract instance;
            if (params == null) {
                Constructor<T> ct = layerClass.getDeclaredConstructor(new Class[0]);
                instance = (LexiconLayerStoredAbstract)ct.newInstance(new Object[0]);
            } else {
                Constructor<T> ct = layerClass.getDeclaredConstructor(paramsClass);
                instance = (LexiconLayerStoredAbstract)ct.newInstance(params);
            }
            this.layersInOrder[layerTag.ordinal()] = instance;
            instance.setLayersConnector(this.connector);
        }
        catch (Exception e) {
            Logger.getLogger(LexiconStored.class.getName()).log(Level.SEVERE, null, e);
        }
        return (T)this.layersInOrder[layerTag.ordinal()];
    }

    @XmlElement(name="entries")
    protected void setEntriesLayer(EntriesLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.ENTRIES.ordinal()] = layer;
    }

    @Override
    public EntriesLayerStored getEntriesLayer() {
        return (EntriesLayerStored)this.layersInOrder[LexiconLayerTag.ENTRIES.ordinal()];
    }

    @XmlElement(name="POStags")
    protected void setPosTagsLayer(PosTagsLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.POSTAGS.ordinal()] = layer;
    }

    @Override
    public PosTagsLayerStored getPosTagsLayer() {
        return (PosTagsLayerStored)this.layersInOrder[LexiconLayerTag.POSTAGS.ordinal()];
    }

    @XmlElement(name="frequencies")
    protected void setFrequenciesLayer(FrequenciesLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.FREQUENCIES.ordinal()] = layer;
    }

    @Override
    public FrequenciesLayerStored getFrequenciesLayer() {
        return (FrequenciesLayerStored)this.layersInOrder[LexiconLayerTag.FREQUENCIES.ordinal()];
    }

    @XmlElement(name="cooccurrences")
    protected void setCooccurrencesLayer(CooccurrencesLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.COOCCURRENCES.ordinal()] = layer;
    }

    @Override
    public CooccurrencesLayerStored getCooccurrencesLayer() {
        return (CooccurrencesLayerStored)this.layersInOrder[LexiconLayerTag.COOCCURRENCES.ordinal()];
    }

    @XmlElement(name="synonyms")
    protected void setSynonymsLayer(SynonymsLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.SYNONYMS.ordinal()] = layer;
    }

    @Override
    public SynonymsLayerStored getSynonymsLayer() {
        return (SynonymsLayerStored)this.layersInOrder[LexiconLayerTag.SYNONYMS.ordinal()];
    }

    @XmlElement(name="syllabifications")
    protected void setSyllabificationsLayer(SyllabificationsLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.SYLLABIFICATIONS.ordinal()] = layer;
    }

    @Override
    public SyllabificationsLayerStored getSyllabificationsLayer() {
        return (SyllabificationsLayerStored)this.layersInOrder[LexiconLayerTag.SYLLABIFICATIONS.ordinal()];
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        this.connectLayers();
    }

    protected void connectLayers() {
        for (int i = 0; i < this.layersInOrder.length; ++i) {
            if (this.layersInOrder[i] == null) continue;
            this.layersInOrder[i].setLayersConnector(this.connector);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(":\n");
        for (LexiconLayerStoredAbstract layer : this.layersInOrder) {
            if (layer == null) continue;
            sb.append(layer);
            sb.append("\n");
        }
        return sb.toString();
    }
}

