/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Entry;
import eu.clarin.weblicht.wlfxb.lx.api.FrequenciesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.Frequency;
import eu.clarin.weblicht.wlfxb.lx.api.FrequencyType;
import eu.clarin.weblicht.wlfxb.lx.xb.FrequencyStored;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="frequencies")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FrequenciesLayerStored
extends LexiconLayerStoredAbstract
implements FrequenciesLayer {
    public static final String XML_NAME = "frequencies";
    @XmlAttribute(name="type")
    private FrequencyType freqType;
    @XmlElement(name="frequency")
    private List<FrequencyStored> frequencies = new ArrayList<FrequencyStored>();
    private LexiconLayersConnector connector;

    protected FrequenciesLayerStored() {
    }

    protected FrequenciesLayerStored(FrequencyType freqType) {
        this.freqType = freqType;
    }

    protected FrequenciesLayerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
        for (FrequencyStored freq : this.frequencies) {
            connector.entry2ItsFreq.put(connector.entryId2ItsEntry.get(freq.entryId), freq);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.frequencies.isEmpty();
    }

    @Override
    public int size() {
        return this.frequencies.size();
    }

    @Override
    public FrequencyType getType() {
        return this.freqType;
    }

    @Override
    public Frequency getFrequency(int index) {
        Frequency freq = this.frequencies.get(index);
        return freq;
    }

    @Override
    public Frequency getFrequency(Entry entry) {
        Frequency freq = this.connector.entry2ItsFreq.get(entry);
        return freq;
    }

    @Override
    public Entry getEntry(Frequency freq) {
        if (freq instanceof FrequencyStored) {
            FrequencyStored freqStored = (FrequencyStored)freq;
            return this.connector.entryId2ItsEntry.get(freqStored.entryId);
        }
        return null;
    }

    @Override
    public Frequency addFrequency(Entry entry, double frequency) {
        FrequencyStored freq = new FrequencyStored();
        freq.value = frequency;
        freq.entryId = entry.getID();
        this.connector.entry2ItsFreq.put(entry, freq);
        this.frequencies.add(freq);
        return freq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.frequencies.toString());
        return sb.toString();
    }
}

