/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.io;

import eu.clarin.weblicht.wlfxb.io.WLFormatException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

public class XmlReaderWriter {
    public static final String XML_WL1_MODEL_PI_NAME = "xml-model";
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String INDENT = "  ";
    private int indent = -1;
    private boolean charsWritten = false;
    private boolean startWritten = false;
    private boolean ispaceWritten = true;
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private XMLEventReader xmlEventReader;
    private XMLEventWriter xmlEventWriter;
    private boolean fragment = false;

    public XmlReaderWriter(XMLEventReader xmlEventReader, XMLEventWriter xmlEventWriter) {
        this.xmlEventReader = xmlEventReader;
        this.xmlEventWriter = xmlEventWriter;
    }

    void setOutputAsXmlFragment(boolean outputAsXmlFragment) {
        this.fragment = outputAsXmlFragment;
    }

    XMLEvent readEvent() throws WLFormatException {
        try {
            return this.xmlEventReader.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    void startExternalFragment(int incIndent) throws XMLStreamException {
        if (!this.ispaceWritten) {
            Characters e = this.eventFactory.createIgnorableSpace(NEW_LINE);
            this.xmlEventWriter.add(e);
            this.ispaceWritten = true;
        }
        for (int i = 0; i < incIndent; ++i) {
            this.incIndent();
        }
        this.addIndent();
    }

    void endExternalFragment(int decIndent) throws XMLStreamException {
        Characters e = this.eventFactory.createIgnorableSpace(NEW_LINE);
        this.xmlEventWriter.add(e);
        this.ispaceWritten = true;
        for (int i = 0; i < decIndent; ++i) {
            this.decIndent();
        }
    }

    void add(XMLEvent xmlEvent) throws XMLStreamException {
        if (this.xmlEventWriter == null) {
            return;
        }
        switch (xmlEvent.getEventType()) {
            case 1: {
                if (!this.ispaceWritten) {
                    Characters e = this.eventFactory.createIgnorableSpace(NEW_LINE);
                    this.xmlEventWriter.add(e);
                }
                this.incIndent();
                this.addIndent();
                this.xmlEventWriter.add(xmlEvent);
                this.charsWritten = false;
                this.startWritten = true;
                this.ispaceWritten = false;
                break;
            }
            case 2: {
                if (!this.charsWritten && !this.startWritten) {
                    if (!this.ispaceWritten) {
                        Characters e = this.eventFactory.createIgnorableSpace(NEW_LINE);
                        this.xmlEventWriter.add(e);
                    }
                    this.addIndent();
                }
                this.decIndent();
                this.xmlEventWriter.add(xmlEvent);
                this.charsWritten = false;
                this.startWritten = false;
                this.ispaceWritten = false;
                break;
            }
            case 4: {
                Characters characters = xmlEvent.asCharacters();
                if (characters.isWhiteSpace()) {
                    if (!this.ispaceWritten) {
                        Characters e = this.eventFactory.createIgnorableSpace(NEW_LINE);
                        this.xmlEventWriter.add(e);
                        this.ispaceWritten = true;
                        this.charsWritten = false;
                    }
                } else {
                    this.xmlEventWriter.add(xmlEvent);
                    this.ispaceWritten = false;
                    this.charsWritten = true;
                }
                this.startWritten = false;
                break;
            }
            case 5: {
                if (!this.ispaceWritten) {
                    Characters e = this.eventFactory.createIgnorableSpace(NEW_LINE);
                    this.xmlEventWriter.add(e);
                }
                this.incIndent();
                this.addIndent();
                this.xmlEventWriter.add(xmlEvent);
                this.decIndent();
                this.charsWritten = false;
                this.ispaceWritten = false;
                this.startWritten = false;
                break;
            }
            case 7: {
                if (!this.fragment) {
                    this.xmlEventWriter.add(xmlEvent);
                }
                this.ispaceWritten = false;
                break;
            }
            case 3: {
                if (!this.fragment) {
                    if (!this.ispaceWritten) {
                        Characters e = this.eventFactory.createIgnorableSpace(NEW_LINE);
                        this.xmlEventWriter.add(e);
                    }
                    this.xmlEventWriter.add(xmlEvent);
                }
                this.ispaceWritten = false;
                break;
            }
            default: {
                this.xmlEventWriter.add(xmlEvent);
                this.charsWritten = false;
                this.ispaceWritten = false;
                this.startWritten = false;
            }
        }
    }

    void incIndent() {
        ++this.indent;
    }

    void decIndent() {
        --this.indent;
    }

    void addIndent() throws XMLStreamException {
        for (int i = 0; i < this.indent; ++i) {
            Characters xmlEvent = this.eventFactory.createIgnorableSpace(INDENT);
            this.xmlEventWriter.add(xmlEvent);
        }
    }

    void close() throws WLFormatException {
        try {
            if (this.xmlEventReader != null) {
                this.xmlEventReader.close();
            }
        }
        catch (XMLStreamException e) {
            try {
                if (this.xmlEventWriter != null) {
                    this.xmlEventWriter.close();
                }
            }
            catch (XMLStreamException e2) {
                throw new WLFormatException(e2);
            }
            throw new WLFormatException(e);
        }
    }

    public void readWriteToTheEnd() throws WLFormatException {
        try {
            while (this.xmlEventReader.hasNext()) {
                this.add(this.xmlEventReader.nextEvent());
            }
            if (this.xmlEventWriter != null) {
                this.xmlEventWriter.flush();
            }
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readWriteElement(String tagName) throws WLFormatException {
        try {
            block5: while (this.xmlEventReader.hasNext()) {
                XMLEvent event = this.xmlEventReader.nextEvent();
                switch (event.getEventType()) {
                    case 2: {
                        this.add(event);
                        if (!event.asEndElement().getName().getLocalPart().equals(tagName)) continue block5;
                        return;
                    }
                }
                this.add(event);
            }
            return;
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    public void readWriteUpToStartElement(String startTag) throws XMLStreamException {
        boolean startTagIsNext = false;
        block3: while (this.xmlEventReader.hasNext() && !startTagIsNext) {
            XMLEvent readEvent;
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            switch (peekedEvent.getEventType()) {
                case 1: {
                    String elementName = peekedEvent.asStartElement().getName().getLocalPart();
                    if (elementName.equals(startTag)) {
                        startTagIsNext = true;
                        continue block3;
                    }
                    readEvent = this.xmlEventReader.nextEvent();
                    this.add(readEvent);
                    continue block3;
                }
            }
            readEvent = this.xmlEventReader.nextEvent();
            this.add(readEvent);
        }
    }

    public void readWriteUpToEndElement(String endTag) throws XMLStreamException {
        boolean endTagIsNext = false;
        block3: while (this.xmlEventReader.hasNext() && !endTagIsNext) {
            XMLEvent readEvent;
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            switch (peekedEvent.getEventType()) {
                case 2: {
                    String elementName = peekedEvent.asEndElement().getName().getLocalPart();
                    if (elementName.equals(endTag)) {
                        endTagIsNext = true;
                        continue block3;
                    }
                    readEvent = this.xmlEventReader.nextEvent();
                    this.add(readEvent);
                    continue block3;
                }
            }
            readEvent = this.xmlEventReader.nextEvent();
            this.add(readEvent);
        }
    }
}

