/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.io;

import eu.clarin.weblicht.wlfxb.io.WLFormatException;
import eu.clarin.weblicht.wlfxb.io.XmlReaderWriter;
import eu.clarin.weblicht.wlfxb.lx.api.LexiconLayer;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerTag;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconStored;
import eu.clarin.weblicht.wlfxb.md.xb.MetaDataItem;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class LexiconStreamed
extends LexiconStored {
    private EnumSet<LexiconLayerTag> layersToRead;
    private EnumSet<LexiconLayerTag> readSucceeded = EnumSet.noneOf(LexiconLayerTag.class);
    private XMLEventReader xmlEventReader;
    private XMLEventWriter xmlEventWriter;
    private XmlReaderWriter xmlReaderWriter;
    private static final int LAYER_INDENT_RELATIVE = 1;
    private boolean closed = false;

    public LexiconStreamed(InputStream inputStream, EnumSet<LexiconLayerTag> layersToRead) throws WLFormatException {
        super("unknown");
        this.layersToRead = layersToRead;
        try {
            this.initializeReaderAndWriter(inputStream, null, false);
            this.process();
        }
        catch (WLFormatException e) {
            this.xmlReaderWriter.close();
            throw e;
        }
    }

    public LexiconStreamed(InputStream inputStream, EnumSet<LexiconLayerTag> layersToRead, OutputStream outputStream) throws WLFormatException {
        super("unknown");
        this.layersToRead = layersToRead;
        try {
            this.initializeReaderAndWriter(inputStream, outputStream, false);
            this.process();
        }
        catch (WLFormatException e) {
            this.xmlReaderWriter.close();
            throw e;
        }
    }

    public LexiconStreamed(InputStream inputStream, EnumSet<LexiconLayerTag> layersToRead, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        super("unknown");
        this.layersToRead = layersToRead;
        try {
            this.initializeReaderAndWriter(inputStream, outputStream, outputAsXmlFragment);
            this.process();
        }
        catch (WLFormatException e) {
            this.xmlReaderWriter.close();
            throw e;
        }
    }

    public LexiconStreamed(InputStream inputStream, EnumSet<LexiconLayerTag> layersToRead, OutputStream outputStream, List<MetaDataItem> metaDataToAdd) throws WLFormatException {
        super("unknown");
        this.layersToRead = layersToRead;
        try {
            this.initializeReaderAndWriter(inputStream, outputStream, false);
            this.addMetadata(metaDataToAdd);
            this.process();
        }
        catch (WLFormatException e) {
            this.xmlReaderWriter.close();
            throw e;
        }
    }

    private void initializeReaderAndWriter(InputStream inputStream, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        if (inputStream != null) {
            try {
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                this.xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream, "UTF-8");
            }
            catch (XMLStreamException e) {
                throw new WLFormatException(e.getMessage(), e);
            }
        }
        if (outputStream != null) {
            try {
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                this.xmlEventWriter = xmlOutputFactory.createXMLEventWriter(outputStream, "UTF-8");
            }
            catch (XMLStreamException e) {
                throw new WLFormatException(e.getMessage(), e);
            }
        }
        this.xmlReaderWriter = new XmlReaderWriter(this.xmlEventReader, this.xmlEventWriter);
        this.xmlReaderWriter.setOutputAsXmlFragment(outputAsXmlFragment);
    }

    private void addMetadata(List<MetaDataItem> metaDataToAdd) throws WLFormatException {
        try {
            this.xmlReaderWriter.readWriteUpToEndElement("MetaData");
            this.marshall(metaDataToAdd);
            XMLEvent event = this.xmlEventReader.nextEvent();
            this.xmlReaderWriter.add(event);
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    private void process() throws WLFormatException {
        try {
            this.xmlReaderWriter.readWriteUpToStartElement("Lexicon");
            XMLEvent event = this.xmlEventReader.nextEvent();
            this.lang = event.asStartElement().getAttributeByName(new QName("lang")).getValue();
            this.xmlReaderWriter.add(event);
            this.processLayers();
            super.connectLayers();
            if (this.xmlEventWriter == null) {
                this.xmlReaderWriter.readWriteToTheEnd();
            }
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        if (this.layersToRead.size() != this.readSucceeded.size()) {
            this.layersToRead.removeAll(this.readSucceeded);
            throw new WLFormatException("Following layers could not be read: " + this.layersToRead.toString());
        }
    }

    private void processLayers() throws WLFormatException {
        boolean textCorpusEnd = false;
        try {
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            while (!textCorpusEnd && peekedEvent != null) {
                if (peekedEvent.getEventType() == 2 && peekedEvent.asEndElement().getName().getLocalPart().equals("Lexicon")) {
                    textCorpusEnd = true;
                    continue;
                }
                if (peekedEvent.getEventType() == 1) {
                    this.processLayer();
                    peekedEvent = this.xmlEventReader.peek();
                    continue;
                }
                XMLEvent readEvent = this.xmlReaderWriter.readEvent();
                this.xmlReaderWriter.add(readEvent);
                peekedEvent = this.xmlEventReader.peek();
            }
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        if (!textCorpusEnd) {
            throw new WLFormatException("Lexicon end tag not found");
        }
    }

    private void processLayer() throws WLFormatException {
        try {
            XMLEvent peekedEvent = this.xmlEventReader.peek();
            String tagName = peekedEvent.asStartElement().getName().getLocalPart();
            LexiconLayerTag layerTag = LexiconLayerTag.getFromXmlName(tagName);
            if (layerTag == null) {
                this.xmlReaderWriter.readWriteElement(tagName);
            } else if (this.layersToRead.contains((Object)layerTag)) {
                this.readLayerData(layerTag);
            } else {
                this.xmlReaderWriter.readWriteElement(tagName);
            }
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    private void readLayerData(LexiconLayerTag layerTag) throws WLFormatException {
        try {
            LexiconLayerStoredAbstract layer;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{layerTag.getLayerClass()});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.layersInOrder[layerTag.ordinal()] = layer = (LexiconLayerStoredAbstract)unmarshaller.unmarshal(this.xmlEventReader);
            this.marshall(this.layersInOrder[layerTag.ordinal()]);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        this.readSucceeded.add(layerTag);
    }

    private void marshall(LexiconLayer layer) throws WLFormatException {
        if (this.xmlEventWriter == null) {
            return;
        }
        try {
            this.xmlReaderWriter.startExternalFragment(1);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{layer.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)layer, this.xmlEventWriter);
            this.xmlReaderWriter.endExternalFragment(1);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    private void marshall(List<MetaDataItem> metaDataToAdd) throws WLFormatException {
        if (this.xmlEventWriter == null) {
            return;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MetaDataItem.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            for (MetaDataItem mdi : metaDataToAdd) {
                this.xmlReaderWriter.startExternalFragment(1);
                marshaller.marshal((Object)mdi, this.xmlEventWriter);
                this.xmlReaderWriter.endExternalFragment(1);
            }
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws WLFormatException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            boolean[] layersRead = new boolean[this.layersInOrder.length];
            for (LexiconLayerTag layerRead : this.layersToRead) {
                layersRead[layerRead.ordinal()] = true;
            }
            for (int i = 0; i < this.layersInOrder.length; ++i) {
                if (this.layersInOrder[i] == null || layersRead[i]) continue;
                this.marshall(this.layersInOrder[i]);
            }
        }
        finally {
            this.xmlReaderWriter.readWriteToTheEnd();
        }
    }
}

