/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.ed.xb;

import eu.clarin.weblicht.wlfxb.ed.api.CanonicalSegmentationLayer;
import eu.clarin.weblicht.wlfxb.ed.api.ExternalData;
import eu.clarin.weblicht.wlfxb.ed.api.ExternalDataLayer;
import eu.clarin.weblicht.wlfxb.ed.api.NamedEntityModelLayer;
import eu.clarin.weblicht.wlfxb.ed.api.PhoneticSegmentationLayer;
import eu.clarin.weblicht.wlfxb.ed.api.SpeechSignalLayer;
import eu.clarin.weblicht.wlfxb.ed.api.TokenSegmentationLayer;
import eu.clarin.weblicht.wlfxb.ed.xb.CanonicalSegmentationLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.ExternalDataLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.ExternalDataLayerTag;
import eu.clarin.weblicht.wlfxb.ed.xb.NamedEntityModelLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.PhoneticSegmentationLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.SpeechSignalLayerStored;
import eu.clarin.weblicht.wlfxb.ed.xb.TokenSegmentationLayerStored;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="ExternalData", namespace="http://www.dspin.de/data/extdata")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"speechSignalLayer", "tokenSegmentationLayer", "phoneticSegmentationLayer", "canonicalSegmentationLayer", "namedEntityModelLayer"})
public class ExternalDataStored
implements ExternalData {
    public static final String XML_NAME = "ExternalData";
    public static final String XML_NAMESPACE = "http://www.dspin.de/data/extdata";
    private ExternalDataLayerStored[] layersInOrder = new ExternalDataLayerStored[ExternalDataLayerTag.orderedLayerTags().size()];

    @Override
    public List<ExternalDataLayer> getLayers() {
        ArrayList<ExternalDataLayer> allLayers = new ArrayList<ExternalDataLayer>(this.layersInOrder.length);
        for (ExternalDataLayerStored layer : this.layersInOrder) {
            if (layer == null) continue;
            allLayers.add(layer);
        }
        return allLayers;
    }

    @Override
    public SpeechSignalLayer createSpeechSignalLayer(String mimeType) {
        SpeechSignalLayer layer = this.initializeLayer(SpeechSignalLayerStored.class, mimeType);
        return layer;
    }

    @Override
    public SpeechSignalLayer createSpeechSignalLayer(String mimeType, int numberOfChannels) {
        SpeechSignalLayer layer = this.initializeLayer(SpeechSignalLayerStored.class, mimeType, new Integer(numberOfChannels));
        return layer;
    }

    @Override
    public TokenSegmentationLayer createTokenSegmentationLayer(String mimeType) {
        TokenSegmentationLayer layer = this.initializeLayer(TokenSegmentationLayerStored.class, mimeType);
        return layer;
    }

    @Override
    public PhoneticSegmentationLayer createPhoneticSegmentationLayer(String mimeType) {
        PhoneticSegmentationLayer layer = this.initializeLayer(PhoneticSegmentationLayerStored.class, mimeType);
        return layer;
    }

    @Override
    public CanonicalSegmentationLayer createCanonicalSegmentationLayer(String mimeType) {
        CanonicalSegmentationLayer layer = this.initializeLayer(CanonicalSegmentationLayerStored.class, mimeType);
        return layer;
    }

    @Override
    public NamedEntityModelLayer createNamedEntityModelLayer(String mimeType, String neType, String modelType) {
        NamedEntityModelLayer layer = this.initializeLayer(NamedEntityModelLayerStored.class, mimeType, neType, modelType);
        return layer;
    }

    private <T extends ExternalDataLayerStored> T initializeLayer(Class<T> layerClass, Object ... params) {
        Class[] paramsClass = null;
        if (params != null) {
            paramsClass = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramsClass[i] = params[i].getClass();
            }
        }
        ExternalDataLayerTag layerTag = ExternalDataLayerTag.getFromClass(layerClass);
        try {
            ExternalDataLayerStored instance;
            if (params == null) {
                Constructor<T> ct = layerClass.getDeclaredConstructor(new Class[0]);
                instance = (ExternalDataLayerStored)ct.newInstance(new Object[0]);
            } else {
                Constructor<T> ct = layerClass.getDeclaredConstructor(paramsClass);
                instance = (ExternalDataLayerStored)ct.newInstance(params);
            }
            this.layersInOrder[layerTag.ordinal()] = instance;
        }
        catch (Exception e) {
            Logger.getLogger(ExternalDataStored.class.getName()).log(Level.SEVERE, null, e);
        }
        return (T)this.layersInOrder[layerTag.ordinal()];
    }

    @XmlElement(name="speechsignal")
    protected void setSpeechSignalLayer(SpeechSignalLayerStored layer) {
        this.layersInOrder[ExternalDataLayerTag.SPEECH_SIGNAL.ordinal()] = layer;
    }

    @Override
    public SpeechSignalLayerStored getSpeechSignalLayer() {
        return (SpeechSignalLayerStored)this.layersInOrder[ExternalDataLayerTag.SPEECH_SIGNAL.ordinal()];
    }

    @XmlElement(name="tokensegmentation")
    protected void setTokenSegmentationLayer(TokenSegmentationLayerStored layer) {
        this.layersInOrder[ExternalDataLayerTag.TOKEN_SEGMENTATION.ordinal()] = layer;
    }

    @Override
    public TokenSegmentationLayerStored getTokenSegmentationLayer() {
        return (TokenSegmentationLayerStored)this.layersInOrder[ExternalDataLayerTag.TOKEN_SEGMENTATION.ordinal()];
    }

    @XmlElement(name="phoneticsegmentation")
    protected void setPhoneticSegmentationLayer(PhoneticSegmentationLayerStored layer) {
        this.layersInOrder[ExternalDataLayerTag.PHONETIC_SEGMENTATION.ordinal()] = layer;
    }

    @Override
    public PhoneticSegmentationLayerStored getPhoneticSegmentationLayer() {
        return (PhoneticSegmentationLayerStored)this.layersInOrder[ExternalDataLayerTag.PHONETIC_SEGMENTATION.ordinal()];
    }

    @XmlElement(name="canonicalsegmentation")
    protected void setCanonicalSegmentationLayer(CanonicalSegmentationLayerStored layer) {
        this.layersInOrder[ExternalDataLayerTag.CANONICAL_SEGMENTATION.ordinal()] = layer;
    }

    @Override
    public CanonicalSegmentationLayerStored getCanonicalSegmentationLayer() {
        return (CanonicalSegmentationLayerStored)this.layersInOrder[ExternalDataLayerTag.CANONICAL_SEGMENTATION.ordinal()];
    }

    @XmlElement(name="namedentitymodel")
    protected void setNamedEntityModelLayer(NamedEntityModelLayerStored layer) {
        this.layersInOrder[ExternalDataLayerTag.NAMEDENTITY_MODEL.ordinal()] = layer;
    }

    @Override
    public NamedEntityModelLayerStored getNamedEntityModelLayer() {
        return (NamedEntityModelLayerStored)this.layersInOrder[ExternalDataLayerTag.NAMEDENTITY_MODEL.ordinal()];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(":\n");
        for (ExternalDataLayerStored layer : this.layersInOrder) {
            if (layer == null) continue;
            sb.append(layer);
            sb.append("\n");
        }
        return sb.toString().trim();
    }

    public static ExternalDataStored compose(ExternalDataLayerStored ... layers) {
        ExternalDataStored ed = new ExternalDataStored();
        ExternalDataLayerStored[] arr$ = layers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ExternalDataLayerStored layer;
            ed.layersInOrder[ExternalDataLayerTag.getFromClass(layer.getClass()).ordinal()] = layer = arr$[i$];
        }
        return ed;
    }
}

