/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.PosTag;
import eu.clarin.weblicht.wlfxb.tc.api.PosTagsLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.PosTagStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="POStags")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PosTagsLayerStored
extends TextCorpusLayerStoredAbstract
implements PosTagsLayer {
    public static final String XML_NAME = "POStags";
    @XmlAttribute(name="tagset", required=true)
    private String tagset;
    @XmlElement(name="tag")
    private List<PosTagStored> tags = new ArrayList<PosTagStored>();
    private TextCorpusLayersConnector connector;

    protected PosTagsLayerStored() {
    }

    protected PosTagsLayerStored(String tagset) {
        this.tagset = tagset;
    }

    protected PosTagsLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (PosTagStored tag : this.tags) {
            for (String tokRef : tag.tokRefs) {
                connector.token2ItsPosTag.put(connector.tokenId2ItsToken.get(tokRef), tag);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public String getTagset() {
        return this.tagset;
    }

    @Override
    public PosTag getTag(int index) {
        PosTag tag = this.tags.get(index);
        return tag;
    }

    @Override
    public PosTag getTag(Token token) {
        PosTag tag = this.connector.token2ItsPosTag.get(token);
        return tag;
    }

    @Override
    public Token[] getTokens(PosTag tag) {
        if (tag instanceof PosTagStored) {
            PosTagStored tagStored = (PosTagStored)tag;
            return WlfUtilities.tokenIdsToTokens(tagStored.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public PosTag addTag(String tagString, Token tagToken) {
        List<Token> tagTokens = Arrays.asList(tagToken);
        return this.addTag(tagString, tagTokens);
    }

    @Override
    public PosTag addTag(String tagString, List<Token> tagTokens) {
        PosTagStored tag = new PosTagStored();
        tag.tagString = tagString;
        tag.tokRefs = new String[tagTokens.size()];
        for (int i = 0; i < tagTokens.size(); ++i) {
            Token token = tagTokens.get(i);
            tag.tokRefs[i] = token.getID();
            this.connector.token2ItsPosTag.put(token, tag);
        }
        this.tags.add(tag);
        return tag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" ");
        sb.append("{");
        sb.append(this.tagset);
        sb.append("} :");
        sb.append(this.tags.toString());
        return sb.toString();
    }
}

