/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.PhoneticsLayer;
import eu.clarin.weblicht.wlfxb.tc.api.PhoneticsSegment;
import eu.clarin.weblicht.wlfxb.tc.api.Pronunciation;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.PhoneticsSegmentStored;
import eu.clarin.weblicht.wlfxb.tc.xb.PronunciationStored;
import eu.clarin.weblicht.wlfxb.tc.xb.PronunciationType;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="phonetics")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PhoneticsLayerStored
extends TextCorpusLayerStoredAbstract
implements PhoneticsLayer {
    public static final String XML_NAME = "phonetics";
    @XmlAttribute(name="alphabet")
    private String alphabet;
    @XmlElement(name="phonseg")
    private List<PhoneticsSegmentStored> phsegs = new ArrayList<PhoneticsSegmentStored>();
    private TextCorpusLayersConnector connector;

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (int i = 0; i < this.phsegs.size(); ++i) {
            PhoneticsSegmentStored phseg = this.phsegs.get(i);
            connector.token2ItsPhseg.put(connector.tokenId2ItsToken.get(phseg.tokRef), phseg);
        }
    }

    protected PhoneticsLayerStored() {
    }

    protected PhoneticsLayerStored(String alphabet) {
        this.alphabet = alphabet;
    }

    protected PhoneticsLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.phsegs.isEmpty();
    }

    @Override
    public int size() {
        return this.phsegs.size();
    }

    @Override
    public String getAlphabet() {
        return this.alphabet;
    }

    @Override
    public PhoneticsSegment getSegment(int index) {
        return this.phsegs.get(index);
    }

    @Override
    public PhoneticsSegment getSegment(Token token) {
        return this.connector.token2ItsPhseg.get(token);
    }

    @Override
    public Token getToken(PhoneticsSegment segment) {
        if (segment instanceof PhoneticsSegmentStored) {
            return this.connector.tokenId2ItsToken.get(((PhoneticsSegmentStored)segment).tokRef);
        }
        throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(PhoneticsSegment.class, PhoneticsLayer.class));
    }

    @Override
    public Pronunciation createPronunciation(PronunciationType type, String canonicalPronunciation, String realizedPronunciation, float onsetInSeconds, float offsetInSeconds, List<Pronunciation> children) {
        PronunciationStored pron = new PronunciationStored();
        pron.type = type;
        pron.cp = canonicalPronunciation;
        pron.rp = realizedPronunciation;
        pron.onset = Float.valueOf(onsetInSeconds);
        pron.offset = Float.valueOf(offsetInSeconds);
        for (Pronunciation child : children) {
            if (child instanceof PronunciationStored) {
                pron.children.add((PronunciationStored)child);
                continue;
            }
            throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Pronunciation.class, PhoneticsLayer.class));
        }
        return pron;
    }

    @Override
    public Pronunciation createPronunciation(PronunciationType type, String canonicalPronunciation, String realizedPronunciation, List<Pronunciation> children) {
        PronunciationStored pron = new PronunciationStored();
        pron.type = type;
        pron.cp = canonicalPronunciation;
        pron.rp = realizedPronunciation;
        for (Pronunciation child : children) {
            if (child instanceof PronunciationStored) {
                pron.children.add((PronunciationStored)child);
                continue;
            }
            throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Pronunciation.class, PhoneticsLayer.class));
        }
        return pron;
    }

    @Override
    public Pronunciation createPronunciation(PronunciationType type, String realizedPronunciation, float onsetInSeconds, float offsetInSeconds, List<Pronunciation> children) {
        PronunciationStored pron = new PronunciationStored();
        pron.type = type;
        pron.rp = realizedPronunciation;
        pron.onset = Float.valueOf(onsetInSeconds);
        pron.offset = Float.valueOf(offsetInSeconds);
        for (Pronunciation child : children) {
            if (child instanceof PronunciationStored) {
                pron.children.add((PronunciationStored)child);
                continue;
            }
            throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Pronunciation.class, PhoneticsLayer.class));
        }
        return pron;
    }

    @Override
    public Pronunciation createPronunciation(PronunciationType type, String realizedPronunciation, float onsetInSeconds, float offsetInSeconds) {
        PronunciationStored pron = new PronunciationStored();
        pron.type = type;
        pron.rp = realizedPronunciation;
        pron.onset = Float.valueOf(onsetInSeconds);
        pron.offset = Float.valueOf(offsetInSeconds);
        return pron;
    }

    @Override
    public Pronunciation createPronunciation(PronunciationType type, String canonicalPronunciation) {
        PronunciationStored pron = new PronunciationStored();
        pron.type = type;
        pron.cp = canonicalPronunciation;
        return pron;
    }

    @Override
    public Pronunciation addChild(Pronunciation parent, Pronunciation child) {
        PronunciationStored parentS = null;
        PronunciationStored childS = null;
        if (!(parent instanceof PronunciationStored)) {
            throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Pronunciation.class, PhoneticsLayer.class));
        }
        parentS = (PronunciationStored)parent;
        if (!(child instanceof PronunciationStored)) {
            throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Pronunciation.class, PhoneticsLayer.class));
        }
        childS = (PronunciationStored)child;
        parentS.children.add(childS);
        return parentS;
    }

    @Override
    public PhoneticsSegment addSegment(Pronunciation pronunciation, Token token) {
        return this.addSegment(Arrays.asList(pronunciation), token);
    }

    @Override
    public PhoneticsSegment addSegment(List<Pronunciation> pronunciations, Token token) {
        PhoneticsSegmentStored phseg = new PhoneticsSegmentStored();
        phseg.tokRef = token.getID();
        for (Pronunciation pron : pronunciations) {
            if (pron instanceof PronunciationStored) {
                phseg.prons.add((PronunciationStored)pron);
                continue;
            }
            throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Pronunciation.class, PhoneticsLayer.class));
        }
        this.phsegs.add(phseg);
        return phseg;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        sb.append("alphabet").append(" ").append(this.alphabet);
        sb.append("}: ");
        sb.append(this.phsegs.toString());
        return sb.toString();
    }
}

