/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Lemma;
import eu.clarin.weblicht.wlfxb.tc.api.LemmasLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.LemmaStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="lemmas")
@XmlAccessorType(value=XmlAccessType.NONE)
public class LemmasLayerStored
extends TextCorpusLayerStoredAbstract
implements LemmasLayer {
    public static final String XML_NAME = "lemmas";
    @XmlElement(name="lemma")
    private List<LemmaStored> lemmas = new ArrayList<LemmaStored>();
    private TextCorpusLayersConnector connector;

    protected LemmasLayerStored() {
    }

    protected LemmasLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (int i = 0; i < this.lemmas.size(); ++i) {
            LemmaStored lemma = this.lemmas.get(i);
            for (String tokRef : lemma.tokRefs) {
                connector.token2ItsLemma.put(connector.tokenId2ItsToken.get(tokRef), lemma);
            }
            if (lemma.lemmaId == null) {
                lemma.lemmaId = "l__" + i;
            }
            connector.lemmaId2ItsLemma.put(lemma.lemmaId, lemma);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.lemmas.isEmpty();
    }

    @Override
    public int size() {
        return this.lemmas.size();
    }

    @Override
    public Lemma getLemma(int index) {
        Lemma lemma = this.lemmas.get(index);
        return lemma;
    }

    @Override
    public Lemma getLemma(Token token) {
        Lemma lemma = this.connector.token2ItsLemma.get(token);
        return lemma;
    }

    @Override
    public Token[] getTokens(Lemma lemma) {
        if (lemma instanceof LemmaStored) {
            LemmaStored lemmaStored = (LemmaStored)lemma;
            return WlfUtilities.tokenIdsToTokens(lemmaStored.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public Lemma addLemma(String lemmaString, Token lemmaToken) {
        List<Token> lemmaTokens = Arrays.asList(lemmaToken);
        return this.addLemma(lemmaString, lemmaTokens);
    }

    @Override
    public Lemma addLemma(String lemmaString, List<Token> lemmaTokens) {
        LemmaStored lemma = new LemmaStored();
        int lemmaCount = this.lemmas.size();
        lemma.lemmaId = "l_" + lemmaCount;
        lemma.lemmaString = lemmaString;
        lemma.tokRefs = new String[lemmaTokens.size()];
        for (int i = 0; i < lemmaTokens.size(); ++i) {
            Token lemmaToken = lemmaTokens.get(i);
            lemma.tokRefs[i] = lemmaToken.getID();
            this.connector.token2ItsLemma.put(lemmaToken, lemma);
        }
        this.lemmas.add(lemma);
        return lemma;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.lemmas.toString());
        return sb.toString();
    }
}

