/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.GeoCapitalFormat;
import eu.clarin.weblicht.wlfxb.tc.api.GeoContinentFormat;
import eu.clarin.weblicht.wlfxb.tc.api.GeoCountryFormat;
import eu.clarin.weblicht.wlfxb.tc.api.GeoLayer;
import eu.clarin.weblicht.wlfxb.tc.api.GeoLongLatFormat;
import eu.clarin.weblicht.wlfxb.tc.api.GeoPoint;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.GeoPointStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="geo")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GeoLayerStored
extends TextCorpusLayerStoredAbstract
implements GeoLayer {
    public static final String XML_NAME = "geo";
    @XmlElement(name="src", required=true)
    private String source;
    @XmlAttribute(name="coordFormat", required=true)
    private GeoLongLatFormat coordFormat;
    @XmlAttribute(name="continentFormat")
    private GeoContinentFormat continentFormat;
    @XmlAttribute(name="countryFormat")
    private GeoCountryFormat countryFormat;
    @XmlAttribute(name="capitalFormat")
    private GeoCapitalFormat capitalFormat;
    @XmlElement(name="gpoint")
    private List<GeoPointStored> points = new ArrayList<GeoPointStored>();
    private TextCorpusLayersConnector connector;

    protected GeoLayerStored() {
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat) {
        this(source, coordFormat, null, null, null);
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat, GeoContinentFormat continentFormat) {
        this(source, coordFormat, continentFormat, null, null);
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat, GeoContinentFormat continentFormat, GeoCountryFormat countryFormat) {
        this(source, coordFormat, continentFormat, countryFormat, null);
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat, GeoContinentFormat continentFormat, GeoCapitalFormat capitalFormat) {
        this(source, coordFormat, continentFormat, null, capitalFormat);
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat, GeoCountryFormat countryFormat) {
        this(source, coordFormat, null, countryFormat, null);
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat, GeoCountryFormat countryFormat, GeoCapitalFormat capitalFormat) {
        this(source, coordFormat, null, countryFormat, capitalFormat);
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat, GeoCapitalFormat capitalFormat) {
        this(source, coordFormat, null, null, capitalFormat);
    }

    protected GeoLayerStored(String source, GeoLongLatFormat coordFormat, GeoContinentFormat continentFormat, GeoCountryFormat countryFormat, GeoCapitalFormat capitalFormat) {
        this.source = source;
        this.coordFormat = coordFormat;
        this.continentFormat = continentFormat;
        this.countryFormat = countryFormat;
        this.capitalFormat = capitalFormat;
    }

    protected GeoLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (GeoPointStored point : this.points) {
            for (String tokRef : point.tokRefs) {
                connector.token2ItsGeopoint.put(connector.tokenId2ItsToken.get(tokRef), point);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public GeoLongLatFormat getCoordinatesFormat() {
        return this.coordFormat;
    }

    @Override
    public GeoContinentFormat getContinentFormat() {
        return this.continentFormat;
    }

    @Override
    public GeoCountryFormat getCountryFormat() {
        return this.countryFormat;
    }

    @Override
    public GeoCapitalFormat getCapitalFormat() {
        return this.capitalFormat;
    }

    @Override
    public GeoPoint getPoint(int index) {
        return this.points.get(index);
    }

    @Override
    public GeoPoint getPoint(Token token) {
        GeoPoint point = this.connector.token2ItsGeopoint.get(token);
        return point;
    }

    @Override
    public Token[] getTokens(GeoPoint point) {
        if (point instanceof GeoPointStored) {
            GeoPointStored p = (GeoPointStored)point;
            return WlfUtilities.tokenIdsToTokens(p.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public GeoPoint addPoint(String longitude, String latitude, Double altitude, String continent, String country, String capital, Token pointToken) {
        List<Token> tokens = Arrays.asList(pointToken);
        return this.addPoint(longitude, latitude, altitude, continent, country, capital, tokens);
    }

    @Override
    public GeoPoint addPoint(String longitude, String latitude, Double altitude, String continent, String country, String capital, List<Token> pointTokens) {
        GeoPointStored p = new GeoPointStored();
        p.longitude = longitude;
        p.latitude = latitude;
        p.altitude = altitude;
        p.continent = continent;
        p.country = country;
        p.capital = capital;
        p.tokRefs = new String[pointTokens.size()];
        for (int i = 0; i < pointTokens.size(); ++i) {
            Token token = pointTokens.get(i);
            p.tokRefs[i] = token.getID();
            this.connector.token2ItsGeopoint.put(token, p);
        }
        this.points.add(p);
        return p;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" ");
        sb.append("{");
        sb.append(this.source);
        sb.append(",");
        sb.append((Object)this.coordFormat);
        if (this.continentFormat != null) {
            sb.append(",");
            sb.append(this.continentFormat.name());
        }
        if (this.countryFormat != null) {
            sb.append(",");
            sb.append(this.countryFormat.name());
        }
        if (this.capitalFormat != null) {
            sb.append(",");
            sb.append(this.capitalFormat.name());
        }
        sb.append("} :");
        sb.append(this.points.toString());
        return sb.toString();
    }
}

