/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Constituent;
import eu.clarin.weblicht.wlfxb.tc.api.ConstituentReference;
import eu.clarin.weblicht.wlfxb.tc.xb.ConstituentReferenceStored;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="constituent")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ConstituentStored
implements Constituent {
    public static final String XML_NAME = "constituent";
    public static final String XML_ATTRIBUTE_CATEGORY = "cat";
    public static final String ID_PREFIX = "c_";
    @XmlAttribute(name="ID")
    protected String constituentId;
    @XmlAttribute(name="cat", required=true)
    protected String category;
    @XmlAttribute(name="edge")
    protected String edge;
    @XmlAttribute(name="tokenIDs")
    protected String[] tokRefs;
    @XmlElement(name="cref")
    protected List<ConstituentReferenceStored> crefs = new ArrayList<ConstituentReferenceStored>();
    @XmlElement(name="constituent")
    protected List<ConstituentStored> children = new ArrayList<ConstituentStored>();

    public boolean isTerminal() {
        return this.children.isEmpty();
    }

    public boolean isEmptyTerminal() {
        return this.isTerminal() && (this.tokRefs == null || this.tokRefs.length == 0);
    }

    public Constituent[] getChildren() {
        if (this.children.isEmpty()) {
            return null;
        }
        Constituent[] childrenAsArray = new Constituent[this.children.size()];
        return this.children.toArray(childrenAsArray);
    }

    public ConstituentReference[] getSecondaryEdgeChildren() {
        ConstituentReference[] crefstemp = new ConstituentReference[this.crefs.size()];
        return this.crefs.toArray(crefstemp);
    }

    public String getCategory() {
        return this.category;
    }

    public String getEdge() {
        return this.edge;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.constituentId != null) {
            sb.append(this.constituentId);
            sb.append(" -> ");
        }
        sb.append(this.category);
        sb.append(" ");
        if (this.edge != null) {
            sb.append(this.edge);
            sb.append(" ");
        }
        if (!this.crefs.isEmpty()) {
            sb.append(this.crefs.toString());
            sb.append(" ");
        }
        if (this.tokRefs != null) {
            sb.append(Arrays.toString(this.tokRefs));
        } else {
            sb.append("( ");
            for (ConstituentStored c : this.children) {
                sb.append(((Object)c).toString());
                sb.append(" ");
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

