/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Lemma;
import eu.clarin.weblicht.wlfxb.lx.api.Relation;
import eu.clarin.weblicht.wlfxb.lx.api.RelationsLayer;
import eu.clarin.weblicht.wlfxb.lx.api.Sig;
import eu.clarin.weblicht.wlfxb.lx.api.Term;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.RelationStored;
import eu.clarin.weblicht.wlfxb.lx.xb.SigStored;
import eu.clarin.weblicht.wlfxb.lx.xb.TermStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="word-relations")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RelationsLayerStored
extends LexiconLayerStoredAbstract
implements RelationsLayer {
    public static final String XML_NAME = "word-relations";
    @XmlElement(name="word-relation")
    private List<RelationStored> rels = new ArrayList<RelationStored>();
    private LexiconLayersConnector connector;

    protected RelationsLayerStored() {
    }

    protected RelationsLayerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
        for (RelationStored rel : this.rels) {
            this.connect(rel);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.rels.isEmpty();
    }

    @Override
    public int size() {
        return this.rels.size();
    }

    @Override
    public Relation getRelation(int index) {
        return this.rels.get(index);
    }

    @Override
    public Relation[] getRelations(Lemma lemma) {
        List<Relation> relList = this.connector.lemma2ItsRels.get(lemma);
        if (relList != null) {
            return relList.toArray(new Relation[relList.size()]);
        }
        return new Relation[0];
    }

    @Override
    public Lemma[] getLemmas(Relation rel) {
        if (rel instanceof RelationStored) {
            RelationStored relStored = (RelationStored)rel;
            ArrayList<Lemma> lemmas = new ArrayList<Lemma>();
            for (TermStored t : relStored.terms) {
                if (t.lemId == null) continue;
                lemmas.add(this.connector.lemmaId2ItsLemma.get(t.lemId));
            }
            return lemmas.toArray(new Lemma[lemmas.size()]);
        }
        return null;
    }

    @Override
    public String[] getWords(Relation rel) {
        if (rel instanceof RelationStored) {
            RelationStored relStored = (RelationStored)rel;
            ArrayList<String> words = new ArrayList<String>();
            for (TermStored t : relStored.terms) {
                if (t.lemId != null) {
                    words.add(this.connector.lemmaId2ItsLemma.get(t.lemId).getString());
                    continue;
                }
                if (t.word == null) continue;
                words.add(t.word);
            }
            return words.toArray(new String[words.size()]);
        }
        return null;
    }

    @Override
    public Relation addRelation(String type, String function, Integer frequency, List<Term> terms) {
        RelationStored rel = new RelationStored();
        rel.type = type;
        rel.function = function;
        rel.freq = frequency;
        for (Term term : terms) {
            if (!(term instanceof TermStored)) continue;
            rel.terms.add((TermStored)term);
        }
        this.connect(rel);
        this.rels.add(rel);
        return rel;
    }

    private void connect(RelationStored rel) {
        for (TermStored term : rel.terms) {
            if (term.lemId == null) continue;
            Lemma lemma = this.connector.lemmaId2ItsLemma.get(term.lemId);
            if (!this.connector.lemma2ItsRels.containsKey(lemma)) {
                this.connector.lemma2ItsRels.put(lemma, new ArrayList());
            }
            this.connector.lemma2ItsRels.get(lemma).add(rel);
        }
    }

    @Override
    public Relation addRelation(String type, String function, Integer frequency, Sig sig, List<Term> terms) {
        RelationStored rel = (RelationStored)this.addRelation(type, function, frequency, terms);
        if (sig instanceof SigStored) {
            rel.sig = (SigStored)sig;
        }
        return rel;
    }

    @Override
    public Term createTerm(Lemma lemma) {
        TermStored term = new TermStored();
        term.lemId = lemma.getID();
        return term;
    }

    @Override
    public Term createTerm(String word) {
        TermStored term = new TermStored();
        term.word = word;
        return term;
    }

    @Override
    public Sig createSig(String measure, double value) {
        SigStored sig = new SigStored(measure, value);
        return sig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.rels.toString());
        return sb.toString();
    }
}

