/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Lemma;
import eu.clarin.weblicht.wlfxb.lx.api.PosTag;
import eu.clarin.weblicht.wlfxb.lx.api.PosTagsLayer;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.PosTagStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="POStags")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PosTagsLayerStored
extends LexiconLayerStoredAbstract
implements PosTagsLayer {
    public static final String XML_NAME = "POStags";
    @XmlAttribute(name="tagset", required=true)
    private String tagset;
    @XmlElement(name="tag")
    private List<PosTagStored> tags = new ArrayList<PosTagStored>();
    private LexiconLayersConnector connector;

    protected PosTagsLayerStored() {
    }

    protected PosTagsLayerStored(String tagset) {
        this.tagset = tagset;
    }

    protected PosTagsLayerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    protected void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
        for (PosTagStored tag : this.tags) {
            this.connect(tag, connector.lemmaId2ItsLemma.get(tag.lemRef));
        }
    }

    private void connect(PosTagStored tag, Lemma lemma) {
        if (!this.connector.lemma2ItsTags.containsKey(lemma)) {
            this.connector.lemma2ItsTags.put(lemma, new ArrayList());
        }
        this.connector.lemma2ItsTags.get(lemma).add(tag);
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public int size() {
        return this.tags.size();
    }

    public String getTagset() {
        return this.tagset;
    }

    public PosTag getTag(int index) {
        PosTag tag = this.tags.get(index);
        return tag;
    }

    public PosTag[] getTags(Lemma lemma) {
        if (this.connector.lemma2ItsTags.containsKey(lemma)) {
            List<PosTag> tagsList = this.connector.lemma2ItsTags.get(lemma);
            PosTag[] posTags = tagsList.toArray(new PosTag[tagsList.size()]);
            return posTags;
        }
        return null;
    }

    public Lemma getLemma(PosTag tag) {
        if (tag instanceof PosTagStored) {
            PosTagStored tagStored = (PosTagStored)tag;
            return this.connector.lemmaId2ItsLemma.get(tagStored.lemRef);
        }
        return null;
    }

    public PosTag addTag(String tagString, Lemma tagLemma) {
        PosTagStored tag = new PosTagStored();
        tag.tagString = tagString;
        tag.lemRef = tagLemma.getID();
        this.connect(tag, tagLemma);
        this.tags.add(tag);
        return tag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.tags.toString());
        return sb.toString();
    }
}

