/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.FrequenciesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.LemmasLayer;
import eu.clarin.weblicht.wlfxb.lx.api.Lexicon;
import eu.clarin.weblicht.wlfxb.lx.api.PosTagsLayer;
import eu.clarin.weblicht.wlfxb.lx.api.RelationsLayer;
import eu.clarin.weblicht.wlfxb.lx.xb.FrequenciesLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.LemmasLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerTag;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.PosTagsLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.RelationsLayerStored;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="Lexicon", namespace="http://www.dspin.de/data/lexicon")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"lemmasLayer", "posTagsLayer", "frequenciesLayer", "relationsLayer"})
public class LexiconStored
implements Lexicon {
    public static final String XML_NAME = "Lexicon";
    public static final String XML_NAMESPACE = "http://www.dspin.de/data/lexicon";
    @XmlAttribute
    protected String lang;
    protected LexiconLayerStoredAbstract[] layersInOrder;
    private LexiconLayersConnector connector = new LexiconLayersConnector();

    LexiconStored() {
        this.layersInOrder = new LexiconLayerStoredAbstract[LexiconLayerTag.orderedLayerTags().size()];
    }

    public LexiconStored(String language) {
        this();
        this.lang = language;
    }

    public String getLanguage() {
        return this.lang;
    }

    @Override
    public LemmasLayer createLemmasLayer() {
        return this.initializeLayer(LemmasLayerStored.class, new Object[0]);
    }

    @Override
    public PosTagsLayer createPosTagsLayer(String tagset) {
        return this.initializeLayer(PosTagsLayerStored.class, tagset);
    }

    @Override
    public FrequenciesLayer createFrequenciesLayer() {
        return this.initializeLayer(FrequenciesLayerStored.class, new Object[0]);
    }

    @Override
    public RelationsLayer createRelationsLayer() {
        return this.initializeLayer(RelationsLayerStored.class, new Object[0]);
    }

    private <T extends LexiconLayerStoredAbstract> T initializeLayer(Class<T> layerClass, Object ... params) {
        Class[] paramsClass = null;
        if (params != null) {
            paramsClass = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramsClass[i] = params[i].getClass();
            }
        }
        LexiconLayerTag layerTag = LexiconLayerTag.getFromClass(layerClass);
        try {
            LexiconLayerStoredAbstract instance;
            if (params == null) {
                Constructor<T> ct = layerClass.getDeclaredConstructor(new Class[0]);
                instance = (LexiconLayerStoredAbstract)ct.newInstance(new Object[0]);
            } else {
                Constructor<T> ct = layerClass.getDeclaredConstructor(paramsClass);
                instance = (LexiconLayerStoredAbstract)ct.newInstance(params);
            }
            this.layersInOrder[layerTag.ordinal()] = instance;
            instance.setLayersConnector(this.connector);
        }
        catch (Exception e) {
            Logger.getLogger(LexiconStored.class.getName()).log(Level.SEVERE, null, e);
        }
        return (T)this.layersInOrder[layerTag.ordinal()];
    }

    @XmlElement(name="lemmas")
    protected void setLemmasLayer(LemmasLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.LEMMAS.ordinal()] = layer;
    }

    @Override
    public LemmasLayerStored getLemmasLayer() {
        return (LemmasLayerStored)this.layersInOrder[LexiconLayerTag.LEMMAS.ordinal()];
    }

    @XmlElement(name="POStags")
    protected void setPosTagsLayer(PosTagsLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.POSTAGS.ordinal()] = layer;
    }

    @Override
    public PosTagsLayerStored getPosTagsLayer() {
        return (PosTagsLayerStored)this.layersInOrder[LexiconLayerTag.POSTAGS.ordinal()];
    }

    @XmlElement(name="frequencies")
    protected void setFrequenciesLayer(FrequenciesLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.FREQUENCIES.ordinal()] = layer;
    }

    @Override
    public FrequenciesLayerStored getFrequenciesLayer() {
        return (FrequenciesLayerStored)this.layersInOrder[LexiconLayerTag.FREQUENCIES.ordinal()];
    }

    @XmlElement(name="word-relations")
    protected void setRelationsLayer(RelationsLayerStored layer) {
        this.layersInOrder[LexiconLayerTag.RELATIONS.ordinal()] = layer;
    }

    @Override
    public RelationsLayerStored getRelationsLayer() {
        return (RelationsLayerStored)this.layersInOrder[LexiconLayerTag.RELATIONS.ordinal()];
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        this.connectLayers();
    }

    protected void connectLayers() {
        for (int i = 0; i < this.layersInOrder.length; ++i) {
            if (this.layersInOrder[i] == null) continue;
            this.layersInOrder[i].setLayersConnector(this.connector);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(":\n");
        for (LexiconLayerStoredAbstract layer : this.layersInOrder) {
            if (layer == null) continue;
            sb.append(layer);
            sb.append("\n");
        }
        return sb.toString();
    }
}

