/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.FrequenciesLayer;
import eu.clarin.weblicht.wlfxb.lx.api.Frequency;
import eu.clarin.weblicht.wlfxb.lx.api.Lemma;
import eu.clarin.weblicht.wlfxb.lx.xb.FrequencyStored;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="frequencies")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FrequenciesLayerStored
extends LexiconLayerStoredAbstract
implements FrequenciesLayer {
    public static final String XML_NAME = "frequencies";
    @XmlElement(name="frequency")
    private List<FrequencyStored> frequencies = new ArrayList<FrequencyStored>();
    private LexiconLayersConnector connector;

    protected FrequenciesLayerStored() {
    }

    protected FrequenciesLayerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    protected void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
        for (FrequencyStored freq : this.frequencies) {
            connector.lemma2ItsFreq.put(connector.lemmaId2ItsLemma.get(freq.lemRef), freq);
        }
    }

    public boolean isEmpty() {
        return this.frequencies.isEmpty();
    }

    public int size() {
        return this.frequencies.size();
    }

    public Frequency getFrequency(int index) {
        Frequency freq = this.frequencies.get(index);
        return freq;
    }

    public Frequency getFrequency(Lemma lemma) {
        Frequency freq = this.connector.lemma2ItsFreq.get(lemma);
        return freq;
    }

    public Lemma getLemma(Frequency freq) {
        if (freq instanceof FrequencyStored) {
            FrequencyStored freqStored = (FrequencyStored)freq;
            return this.connector.lemmaId2ItsLemma.get(freqStored.lemRef);
        }
        return null;
    }

    public Frequency addFrequency(Lemma lemma, int frequency) {
        FrequencyStored freq = new FrequencyStored();
        freq.value = frequency;
        freq.lemRef = lemma.getID();
        this.connector.lemma2ItsFreq.put(lemma, freq);
        this.frequencies.add(freq);
        return freq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.frequencies.toString());
        return sb.toString();
    }
}

