/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.utils;

import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;

public class XPathCreator {
    private XPathCreator() {
    }

    @NotNull
    public static String createAbsolutePath(@NotNull Element element) {
        Parent parent;
        StringBuilder builder = new StringBuilder();
        builder.append(element.getName());
        Element actual = element;
        while ((parent = actual.getParent()) != null) {
            if (parent instanceof Element) {
                int index = XPathCreator.calculateIndex((Element)parent, actual) + 1;
                if (index != 1) {
                    builder.insert(actual.getName().length(), "[" + index + ']');
                }
                actual = (Element)parent;
                builder.insert(0, '/');
                builder.insert(0, actual.getName());
                continue;
            }
            if (parent instanceof Document) {
                builder.insert(0, '/');
                break;
            }
            throw new IllegalStateException("uups " + parent);
        }
        return builder.toString();
    }

    private static int calculateIndex(@NotNull Element parent, @NotNull Element child) {
        if (child.getParent() != parent) {
            throw new IllegalArgumentException("Wrong parent. Expected " + parent + " but was: " + child.getParent());
        }
        List children = parent.getChildren(child.getName());
        return children.indexOf(child);
    }
}

