/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.utils;

import eu.cedarsoft.utils.StringConverter;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverterManager {
    private final Map<Class<?>, StringConverter<?>> converterMap = new HashMap();

    public StringConverterManager() {
        this(false);
    }

    public StringConverterManager(boolean addDefaultConverters) {
        if (addDefaultConverters) {
            this.converterMap.put(String.class, new StringStringConverter());
            this.converterMap.put(Rectangle.class, new RectangleConverter());
            this.converterMap.put(Point.class, new PointConverter());
            this.converterMap.put(Class.class, new ClassConverter());
            this.converterMap.put(File.class, new FileConverter());
            this.converterMap.put(Boolean.class, new BooleanConverter());
        }
    }

    public Map<Class<?>, StringConverter<?>> getConverterMap() {
        return Collections.unmodifiableMap(this.converterMap);
    }

    public void setStringConverters(Map<Class<?>, StringConverter<?>> converters) {
        this.converterMap.clear();
        this.converterMap.putAll(converters);
    }

    public <T> void addStringConverter(Class<T> type, StringConverter<T> converter) {
        this.converterMap.put(type, converter);
    }

    @NotNull
    public <T> StringConverter<T> findConverter(@NotNull Class<? extends T> type) {
        StringConverter<?> converter = this.converterMap.get(type);
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("no converter found for " + type);
    }

    @NotNull
    public String serialize(@NotNull Object object) {
        return this.findConverter(object.getClass()).createRepresentation(object);
    }

    @NotNull
    public <T> T deserialize(@NotNull Class<T> type, @NotNull String representation) {
        return this.findConverter(type).createObject(representation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringStringConverter
    implements StringConverter<String> {
        @Override
        @NotNull
        @NonNls
        public String createRepresentation(@NonNls @NotNull String object) {
            return object;
        }

        @Override
        @NotNull
        public String createObject(@NotNull @NonNls String representation) {
            return representation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PointConverter
    implements StringConverter<Point> {
        @Override
        @NotNull
        @NonNls
        public String createRepresentation(@NotNull Point object) {
            return object.x + ":" + object.y;
        }

        @Override
        @NotNull
        public Point createObject(@NotNull String representation) {
            String[] parts = representation.split("\\:");
            return new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RectangleConverter
    implements StringConverter<Rectangle> {
        @Override
        @NotNull
        @NonNls
        public String createRepresentation(@NotNull Rectangle object) {
            return object.x + ":" + object.y + ':' + object.width + ':' + object.height;
        }

        @Override
        @NotNull
        public Rectangle createObject(@NotNull String representation) {
            String[] parts = representation.split("\\:");
            return new Rectangle(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassConverter
    implements StringConverter<Class<?>> {
        @Override
        @NotNull
        public String createRepresentation(@NotNull Class<?> object) {
            return object.getName();
        }

        @Override
        @NotNull
        public Class<?> createObject(@NotNull String representation) {
            try {
                return Class.forName(representation);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileConverter
    implements StringConverter<File> {
        @Override
        @NotNull
        public String createRepresentation(@NotNull File object) {
            return object.getAbsolutePath();
        }

        @Override
        @NotNull
        public File createObject(@NotNull String representation) {
            return new File(representation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanConverter
    implements StringConverter<Boolean> {
        @Override
        @NotNull
        @NonNls
        public String createRepresentation(@NotNull Boolean object) {
            return object.toString();
        }

        @Override
        @NotNull
        public Boolean createObject(@NotNull @NonNls String representation) {
            return Boolean.parseBoolean(representation);
        }
    }
}

