/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.utils;

import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class StagedPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    @NotNull
    @NonNls
    public static final String STAGE_KEY = "stage";
    @NonNls
    private String actualStage;

    @NotNull
    @NonNls
    public String getActualStage() {
        if (this.actualStage == null) {
            this.actualStage = System.getProperty(STAGE_KEY);
            if (this.actualStage == null || this.actualStage.length() == 0 || this.actualStage.equals("null")) {
                this.actualStage = "dev";
            }
        }
        return this.actualStage;
    }

    public void setActualStage(@NotNull @NonNls String actualStage) {
        this.actualStage = actualStage;
    }

    protected void processProperties(@NotNull ConfigurableListableBeanFactory beanFactoryToProcess, @NotNull Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, this.filter(props));
    }

    @NotNull
    private Properties filter(@NotNull Properties props) {
        String stage = this.getActualStage();
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (!key.startsWith(stage)) continue;
            String newKey = key.substring(stage.length() + 1);
            result.setProperty(newKey, (String)entry.getValue());
        }
        return result;
    }
}

